package ext.chart {
import ext.app.ViewController;
import ext.app.ViewModel;
import ext.data.Session;
import ext.mixin.IBindable;
import ext.mixin.Observable;

[Native("Ext.chart.Caption", require)]
[ExtConfig]
/**
 * Chart captions can be used to place titles, subtitles, credits and other captions
 * inside a chart. Please see the chart's →<code>ext.chart.AbstractChart.captions</code>
 * config documentation for the general description of the way captions work, and
 * refer to the documentation of this class' configs for details.
 * @see ext.chart.AbstractChart#captions
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.Caption.html Original Ext JS documentation of 'Ext.chart.Caption'
 */
public class ChartCaption extends Observable implements IBindable {
  /**
   * @inheritDoc
   */
  public function ChartCaption(config:ChartCaption = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * Determines the horizontal alignment of the caption's text.
   * @default 'center'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.Caption.html#cfg-align Original Ext JS documentation of 'align'
   * @see #getAlign()
   * @see #setAlign()
   */
  public native function get align():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set align(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Whether to align the caption to the 'series' (default) or the 'chart'.
   * @default 'series'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.Caption.html#cfg-alignTo Original Ext JS documentation of 'alignTo'
   * @see #getAlignTo()
   * @see #setAlignTo()
   */
  public native function get alignTo():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set alignTo(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Setting this config option adds or removes data bindings for other configs.
   * For example, to bind the <code>title</code> config:
   * <pre>
   *  var panel = Ext.create({
   *      xtype: 'panel',
   *      bind: {
   *          title: 'Hello {user.name}'
   *      }
   *  });
   * </pre>
   * <p>To dynamically add bindings:</p>
   * <pre>
   *  panel.setBind({
   *      title: 'Greetings {user.name}!'
   *  });
   * </pre>
   * <p>To remove bindings:</p>
   * <pre>
   *  panel.setBind({
   *      title: null
   *  });
   * </pre>
   * <p>The bind expressions are presented to <code>→ext.app.ViewModel.bind()</code>. The
   * <code>ViewModel</code> instance is determined by <code>→lookupViewModel()</code>.</p>
   * <p><b>Note:</b> If bind is passed as a string, it will use the
   * →<code>ext.Component.defaultBindProperty</code> for the binding.</p>
   * @default null
   * @see ext.app.ViewModel#bind()
   * @see #lookupViewModel()
   * @see ext.Component#defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-bind Original Ext JS documentation of 'bind'
   * @see #getBind()
   * @see #setBind()
   */
  public native function get bind():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set bind(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * A string alias, a configuration object or an instance of a <code>ViewController</code> for
   * this container. Sample usage:
   * <pre>
   * Ext.define('MyApp.UserController', {
   *     alias: 'controller.user'
   * });
   *
   * Ext.define('UserContainer', {
   *     extend: 'Ext.container.container',
   *     controller: 'user'
   * });
   * // Or
   * Ext.define('UserContainer', {
   *     extend: 'Ext.container.container',
   *     controller: {
   *         type: 'user',
   *         someConfig: true
   *     }
   * });
   *
   * // Can also instance at runtime
   * var ctrl = new MyApp.UserController();
   * var view = new UserContainer({
   *     controller: ctrl
   * });
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-controller Original Ext JS documentation of 'controller'
   * @see #getController()
   * @see #setController()
   */
  public native function get controller():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set controller(value:*):void;

  /**
   * This property is used to determine the property of a <code>→bind</code> config that is just
   * the value. For example, if <code>defaultBindProperty="value"</code>, then this shorthand
   * <code>→bind</code> config:
   * <pre>
   *  bind: '{name}'
   * </pre>
   * <p>Is equivalent to this object form:</p>
   * <pre>
   *  bind: {
   *      value: '{name}'
   *  }
   * </pre>
   * <p>The <code>→defaultBindProperty</code> is set to "value" for form fields and to "store" for
   * grids and trees.</p>
   * @see #bind
   * @see #defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#property-defaultBindProperty Original Ext JS documentation of 'defaultBindProperty'
   */
  public native function get defaultBindProperty():String;

  /**
   * @private
   */
  public native function set defaultBindProperty(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * If <code>true</code>, this component will be the default scope (this pointer) for events
   * specified with string names so that the scope can be dynamically resolved. The
   * component will automatically become the defaultListenerScope if a
   * →<code>controller</code> is specified.
   * <p>See the introductory docs for →<code>ext.container.Container</code> for some sample
   * usages.</p>
   * <p><b>NOTE</b>: This value can only be reliably set at construction time. Setting it
   * after that time may not correctly rewire all of the potentially effected
   * listeners.</p>
   * @default false
   * @see #controller
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-defaultListenerScope Original Ext JS documentation of 'defaultListenerScope'
   * @see #getDefaultListenerScope()
   * @see #setDefaultListenerScope()
   */
  public native function get defaultListenerScope():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set defaultListenerScope(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The position of the caption in a chart.
   * @default 'top'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.Caption.html#cfg-docked Original Ext JS documentation of 'docked'
   * @see #getDocked()
   * @see #setDocked()
   */
  public native function get docked():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set docked(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Controls the visibility of the caption.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.Caption.html#cfg-hidden Original Ext JS documentation of 'hidden'
   * @see #getHidden()
   * @see #setHidden()
   */
  public native function get hidden():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set hidden(value:Boolean):void;

  [ExtConfig]
  /**
   * Set to <code>true</code> for this component's <code>name</code> property to be tracked by its containing
   * <code>nameHolder</code>.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-nameable Original Ext JS documentation of 'nameable'
   */
  public native function get nameable():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set nameable(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The uniform padding applied to both top and bottom of the caption's text.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.Caption.html#cfg-padding Original Ext JS documentation of 'padding'
   * @see #getPadding()
   * @see #setPadding()
   */
  public native function get padding():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set padding(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>→reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState()</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default null
   * @since 5.0.0
   * @see #reference
   * @see #publishState()
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  public native function get publishes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set publishes(value:*):void;

  [ExtConfig]
  /**
   * Specifies a name for this component inside its component hierarchy. This name
   * must be unique within its <i>view</i> (→<code>ext.container.Container.referenceHolder</code>)
   * or its →<code>ext.app.ViewController</code>. See the documentation in
   * →<code>ext.container.Container</code> for more information about references.
   * <p><b>Note</b>: Valid identifiers start with a letter or underscore and are followed
   * by zero or more additional letters, underscores or digits. References are case
   * sensitive.</p>
   * @see ext.container.Container#referenceHolder
   * @see ext.app.ViewController
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-reference Original Ext JS documentation of 'reference'
   */
  public native function get reference():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set reference(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * If provided this creates a new <code>Session</code> instance for this component. If this
   * is a <code>Container</code>, this will then be inherited by all child components.
   * <p>To create a new session you can specify <code>true</code>:</p>
   * <pre>
   *  Ext.create({
   *      xtype: 'viewport',
   *      session: true,
   *
   *      items: [{
   *          ...
   *      }]
   *  });
   * </pre>
   * <p>Alternatively, a config object can be provided:</p>
   * <pre>
   *  Ext.create({
   *      xtype: 'viewport',
   *      session: {
   *          ...
   *      },
   *
   *      items: [{
   *          ...
   *      }]
   *  });
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-session Original Ext JS documentation of 'session'
   * @see #getSession()
   * @see #setSession()
   */
  public native function get session():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set session(value:*):void;

  [ExtConfig]
  /**
   * Set to <code>true</code> to allow this component's <code>name</code> to be shared by other items in the
   * same <code>nameHolder</code>. Such items will be returned in an array from <code>lookupName</code>.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-shareableName Original Ext JS documentation of 'shareableName'
   */
  public native function get shareableName():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set shareableName(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Style attributes for the caption's text.
   * All attributes that are valid <i>text sprite</i> (→<code>ext.draw.sprite.TextSprite</code>) attributes
   * are valid here. However, only font attributes (such as <code>fontSize</code>, <code>fontFamily</code>, ...),
   * color attributes (such as <code>fillStyle</code>) and <code>textAlign</code> attribute are guaranteed to
   * produce correct behavior. For example, transform attributes are not officially supported.
   * @default {
   *     fontSize: '14px',
   *     fontWeight: 'bold',
   *     fontFamily: 'Verdana, Aria, sans-serif'
   * }
   * @see ext.draw.sprite.TextSprite
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.Caption.html#cfg-style Original Ext JS documentation of 'style'
   * @see #getStyle()
   * @see #setStyle()
   */
  public native function get style():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set style(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The text displayed by the caption.
   * Multi-line captions are allowed, e.g.:
   * <pre>
   * captions: {
   *     title: {
   *         text: 'India\'s tiger population\n'
   *             + 'from 1970 to 2015'
   *     }
   * }
   * </pre>
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.Caption.html#cfg-text Original Ext JS documentation of 'text'
   * @see #getText()
   * @see #setText()
   */
  public native function get text():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set text(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * This object holds a map of <code>config</code> properties that will update their binding
   * as they are modified. For example, <code>value</code> is a key added by form fields. The
   * form of this config is the same as <code>→publishes</code>.
   * <p>This config is defined so that updaters are not created and added for all
   * bound properties since most cannot be modified by the end-user and hence are
   * not appropriate for two-way binding.</p>
   * @default null
   * @see #publishes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-twoWayBindable Original Ext JS documentation of 'twoWayBindable'
   * @see #getTwoWayBindable()
   * @see #setTwoWayBindable()
   */
  public native function get twoWayBindable():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set twoWayBindable(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The <code>ViewModel</code> is a data provider for this component and its children. The
   * data contained in the <code>ViewModel</code> is typically used by adding <code>→bind</code> configs
   * to the components that want present or edit this data.
   * <p>When set, the <code>ViewModel</code> is created and links to any inherited <code>→viewModel</code>
   * instance from an ancestor container as the "parent". The <code>ViewModel</code> hierarchy,
   * once established, only supports creation or destruction of children. The
   * parent of a <code>ViewModel</code> cannot be changed on the fly.</p>
   * <p>If this is a root-level <code>ViewModel</code>, the data model connection is made to this
   * component's associated <code>Data Session (→ext.data.Session)</code>. This is
   * determined by calling <code>getInheritedSession</code>.</p>
   * @default null
   * @see #bind
   * @see #viewModel
   * @see ext.data.Session
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-viewModel Original Ext JS documentation of 'viewModel'
   * @see #getViewModel()
   * @see #setViewModel()
   */
  public native function get viewModel():ViewModel;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set viewModel(value:ViewModel):void;

  [ExtConfig]
  [Bindable]
  /**
   * The weight controls the order in which the captions are created.
   * Captions with lower weights are created first.
   * This affects chart's layout. For example, if two captions are docked
   * to the 'top', the one with the lower weight will end up on top
   * of the other.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.Caption.html#cfg-weight Original Ext JS documentation of 'weight'
   * @see #getWeight()
   * @see #setWeight()
   */
  public native function get weight():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set weight(value:*):void;

  /**
   * Returns the value of <code>align</code>.
   * @see #align
   */
  public native function getAlign():String;

  /**
   * Returns the value of <code>alignTo</code>.
   * @see #alignTo
   */
  public native function getAlignTo():String;

  /**
   * Returns the value of <code>bind</code>.
   * @see #bind
   */
  public native function getBind():*;

  /**
   * Returns the value of <code>controller</code>.
   * @see #controller
   */
  public native function getController():*;

  /**
   * Returns the value of <code>defaultListenerScope</code>.
   * @see #defaultListenerScope
   */
  public native function getDefaultListenerScope():Boolean;

  /**
   * Returns the value of <code>docked</code>.
   * @see #docked
   */
  public native function getDocked():String;

  /**
   * Returns the value of <code>hidden</code>.
   * @see #hidden
   */
  public native function getHidden():Boolean;

  /**
   * Returns the value of <code>padding</code>.
   * @see #padding
   */
  public native function getPadding():Number;

  /**
   * Returns the value of <code>publishes</code>.
   * @see #publishes
   */
  public native function getPublishes():*;

  /**
   * Returns the value of <code>session</code>.
   * @see #session
   */
  public native function getSession():*;

  /**
   * Returns the value of <code>style</code>.
   * @see #style
   */
  public native function getStyle():Object;

  /**
   * Returns the value of <code>text</code>.
   * @see #text
   */
  public native function getText():String;

  /**
   * Returns the value of <code>twoWayBindable</code>.
   * @see #twoWayBindable
   */
  public native function getTwoWayBindable():*;

  /**
   * Returns the value of <code>viewModel</code>.
   * @see #viewModel
   */
  public native function getViewModel():*;

  /**
   * Returns the value of <code>weight</code>.
   * @see #weight
   */
  public native function getWeight():*;

  /**
   * Called by <code>getInherited</code> to initialize the inheritedState the first time it is
   * requested.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#method-initInheritedState Original Ext JS documentation of 'initInheritedState'
   */
  protected native function initInheritedState(inheritedState:*):void;

  /**
   * @inheritDoc
   */
  public native function isBound(name:String = null):Boolean;

  /**
   * @inheritDoc
   */
  public native function lookupController(skipThis:Boolean = false):ViewController;

  /**
   * @inheritDoc
   */
  public native function lookupSession(skipThis:Boolean = false):Session;

  /**
   * @inheritDoc
   */
  public native function lookupViewModel(skipThis:Boolean = false):ViewModel;

  /**
   * Publish this components state to the <code>ViewModel</code>. If no arguments are given (or if
   * this is the first call), the entire state is published. This state is determined by
   * the <code>→publishes</code> property.
   * <p>This method is called only by component authors.</p>
   * @since 5.0.0
   * @param property The name of the property to update.
   * @param value The value of <code>property</code>. Only needed if <code>property</code> is given.
   * @see #publishes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#method-publishState Original Ext JS documentation of 'publishState'
   */
  protected native function publishState(property:String = null, value:Object = null):void;

  /**
   * Sets the value of <code>align</code>.
   * @param align The new value.
   * @see #align
   */
  public native function setAlign(align:String):void;

  /**
   * Sets the value of <code>alignTo</code>.
   * @param alignTo The new value.
   * @see #alignTo
   */
  public native function setAlignTo(alignTo:String):void;

  /**
   * Sets the value of <code>bind</code>.
   * @param bind The new value.
   * @see #bind
   */
  public native function setBind(bind:*):void;

  /**
   * Sets the value of <code>controller</code>.
   * @param controller The new value.
   * @see #controller
   */
  public native function setController(controller:*):void;

  /**
   * Sets the value of <code>defaultListenerScope</code>.
   * @param defaultListenerScope The new value.
   * @see #defaultListenerScope
   */
  public native function setDefaultListenerScope(defaultListenerScope:Boolean):void;

  /**
   * Sets the value of <code>docked</code>.
   * @param docked The new value.
   * @see #docked
   */
  public native function setDocked(docked:String):void;

  /**
   * Sets the value of <code>hidden</code>.
   * @param hidden The new value.
   * @see #hidden
   */
  public native function setHidden(hidden:Boolean):void;

  /**
   * Sets the value of <code>padding</code>.
   * @param padding The new value.
   * @see #padding
   */
  public native function setPadding(padding:Number):void;

  /**
   * Sets the value of <code>publishes</code>.
   * @param publishes The new value.
   * @see #publishes
   */
  public native function setPublishes(publishes:*):void;

  /**
   * Sets the value of <code>session</code>.
   * @param session The new value.
   * @see #session
   */
  public native function setSession(session:*):void;

  /**
   * Sets the value of <code>style</code>.
   * @param style The new value.
   * @see #style
   */
  public native function setStyle(style:Object):void;

  /**
   * Sets the value of <code>text</code>.
   * @param text The new value.
   * @see #text
   */
  public native function setText(text:String):void;

  /**
   * Sets the value of <code>twoWayBindable</code>.
   * @param twoWayBindable The new value.
   * @see #twoWayBindable
   */
  public native function setTwoWayBindable(twoWayBindable:*):void;

  /**
   * Sets the value of <code>viewModel</code>.
   * @param viewModel The new value.
   * @see #viewModel
   */
  public native function setViewModel(viewModel:*):void;

  /**
   * Sets the value of <code>weight</code>.
   * @param weight The new value.
   * @see #weight
   */
  public native function setWeight(weight:*):void;
}
}