package ext.chart {
import ext.Mixin;

[Native("Ext.chart.MarkerHolder", require)]
/**
 * Mixin that provides the functionality to place markers.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.MarkerHolder.html Original Ext JS documentation of 'Ext.chart.MarkerHolder'
 */
public class ChartMarkerHolder extends Mixin implements IChartMarkerHolder {
  /**
   * Registers the given marker with the marker holder under the specified name.
   * @param name The name of the marker (e.g., "items", "labels", etc.).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.MarkerHolder.html#method-bindMarker Original Ext JS documentation of 'bindMarker'
   */
  public native function bindMarker(name:String, marker:ChartMarkers):void;

  [ArrayElementType("ext.chart.ChartMarkers")]
  [Deprecated(replacement="getMarker", since="6.0")]
  /**
   * Returns the markers bound to the given name.
   * @param name The name of the marker (e.g., "items", "labels", etc.).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.MarkerHolder.html#method-getBoundMarker Original Ext JS documentation of 'getBoundMarker'
   */
  public native function getBoundMarker(name:String):Array;

  /**
   * Returns the marker bound to the given name (or null). See →<code>bindMarker()</code>.
   * @param name The name of the marker (e.g., "items", "labels", etc.).
   * @see #bindMarker()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.MarkerHolder.html#method-getMarker Original Ext JS documentation of 'getMarker'
   */
  public native function getMarker(name:String):ChartMarkers;

  /**
   * Unregisters the given marker or a marker with the given name.
   * Providing a name of the marker is more efficient as it avoids lookup.
   * @return Released marker or null.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.MarkerHolder.html#method-releaseMarker Original Ext JS documentation of 'releaseMarker'
   */
  public native function releaseMarker(marker:*):ChartMarkers;
}
}