package ext.chart {
import ext.draw.sprite.InstancingSprite;
import ext.mixin.Observable;

[Native("Ext.chart.Markers", require)]
/**
 * Marker sprite. A specialized version of instancing sprite that groups instances.
 * Putting a marker is grouped by its category id. Clearing removes that category.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.Markers.html Original Ext JS documentation of 'Ext.chart.Markers'
 */
public class ChartMarkers extends InstancingSprite {
  /**
   * @inheritDoc
   */
  public function ChartMarkers(config:ChartMarkers = null) {
    super(config);
  }

  /**
   * Clears the markers in the category.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.Markers.html#method-clear Original Ext JS documentation of 'clear'
   */
  public native function clear(category:String):void;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.Markers.html#method-getMarkerBBoxFor Original Ext JS documentation of 'getMarkerBBoxFor'
   */
  public native function getMarkerBBoxFor(category:String, index:*, isWithoutTransform:Boolean = false):void;

  /**
   * Puts a marker in the category with additional attributes.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.Markers.html#method-putMarkerFor Original Ext JS documentation of 'putMarkerFor'
   */
  public native function putMarkerFor(category:String, attr:Object, index:*, bypassNormalization:Boolean = false, keepRevision:Boolean = false):void;
}
}