package ext.chart {
[Native("Ext.chart.PolarChart", require)]
/**
 * Represent a chart that uses polar coordinates.
 * A polar chart has two axes: an angular axis (which is a circle) and
 * a radial axis (a straight line from the center to the edge of the circle).
 * The angular axis is usually a Category axis while the radial axis is
 * typically numerical.
 * <p>Pie charts and Radar charts are common examples of Polar charts.</p>
 * <p>Please check out the summary for the →<code>ext.chart.AbstractChart</code> as well,
 * for helpful tips and important details.</p>
 * @see ext.chart.AbstractChart
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.PolarChart.html Original Ext JS documentation of 'Ext.chart.PolarChart'
 */
public class PolarChart extends AbstractChart {
  /**
   * @inheritDoc
   */
  public function PolarChart(config:PolarChart = null) {
    super(config);
  }

  [ExtConfig("center")]
  [Bindable]
  /**
   * Alias for <code>center</code> config to avoid name-clash with <code>center()</code> method.
   */
  public native function get center_():Array;

  [ExtConfig("center")]
  [Bindable]
  /**
   * @private
   */
  public native function set center_(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * The amount of inner padding in pixels.
   * Inner padding is the padding from the outermost angular axis to the series.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.PolarChart.html#cfg-innerPadding Original Ext JS documentation of 'innerPadding'
   * @see #getInnerPadding()
   * @see #setInnerPadding()
   */
  public native function get innerPadding():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set innerPadding(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Determines the radius of the polar chart.
   * Updated when the chart performs layout.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.PolarChart.html#cfg-radius Original Ext JS documentation of 'radius'
   * @see #getRadius()
   * @see #setRadius()
   */
  public native function get radius():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set radius(value:Number):void;

  /**
   * Returns the value of <code>center</code>.
   * @see #center
   */
  public native function getCenter():Array;

  /**
   * Returns the value of <code>innerPadding</code>.
   * @see #innerPadding
   */
  public native function getInnerPadding():Number;

  /**
   * Returns the value of <code>radius</code>.
   * @see #radius
   */
  public native function getRadius():Number;

  /**
   * Sets the value of <code>center</code>.
   * @param center The new value.
   * @see #center
   */
  public native function setCenter(center:Array):void;

  /**
   * Sets the value of <code>innerPadding</code>.
   * @param innerPadding The new value.
   * @see #innerPadding
   */
  public native function setInnerPadding(innerPadding:Number):void;

  /**
   * Sets the value of <code>radius</code>.
   * @param radius The new value.
   * @see #radius
   */
  public native function setRadius(radius:Number):void;
}
}