package ext.chart.axis {
import ext.chart.AbstractChart;
import ext.mixin.Observable;
import ext.util.MixedCollection;

[Native("Ext.chart.axis.Axis", require)]
[ExtConfig]
/**
 * @see ext.chart.axis.events.Axis_range_oldRangeEvent.RANGE_CHANGE
 * @eventType ext.chart.axis.events.Axis_range_oldRangeEvent.RANGE_CHANGE
 */
[Event(name='onRangeChange', type='ext.chart.axis.events.Axis_range_oldRangeEvent')]
/**
 * @see ext.chart.axis.events.Axis_visibleRangeEvent.VISIBLE_RANGE_CHANGE
 * @eventType ext.chart.axis.events.Axis_visibleRangeEvent.VISIBLE_RANGE_CHANGE
 */
[Event(name='onVisibleRangeChange', type='ext.chart.axis.events.Axis_visibleRangeEvent')]
/**
 * Defines axis for charts.
 * <p>Using the current model, the type of axis can be easily extended. By default, Sencha Charts
 * provide three different types of axis:</p>
 * <ul>
 * <li><b>numeric</b> - the data attached to this axis is numeric and continuous.</li>
 * <li><b>time</b> - the data attached to this axis is (or gets converted into) a date/time value;
 * it is continuous.</li>
 * <li><b>category</b> - the data attached to this axis belongs to a finite set. The data points
 * are evenly placed along the axis.</li>
 * </ul>
 * <p>The behavior of an axis can be easily changed by setting different types of axis layout and
 * axis segmenter to the axis.</p>
 * <p>Axis layout defines how the data points are placed. Using continuous layout, the data points
 * will be distributed by the numeric value. Using discrete layout the data points will be spaced
 * evenly. Furthermore, if you want to combine the data points with the duplicate values in a
 * discrete layout, you should use combineDuplicate layout.</p>
 * <p>Segmenter defines the way to segment data range. For example, if you have a Date-type data range
 * from Jan 1, 1997 to Jan 1, 2017, the segmenter will segement the data range into years, months or
 * days based on the current zooming level.</p>
 * <p>It is possible to write custom axis layouts and segmenters to extends this behavior by simply
 * implementing interfaces →<code>ext.chart.axis.layout.AxisLayout</code> and
 * →<code>ext.chart.axis.segmenter.AxisSegmenter</code>.</p>
 * <p>Here's an example for the axes part of a chart definition:
 * An example of axis for a series (in this case for an area chart that has multiple layers of
 * yFields) could be:</p>
 * <pre>
 * axes: [{
 *     type: 'numeric',
 *     position: 'left',
 *     title: 'Number of Hits',
 *     grid: {
 *         odd: {
 *             opacity: 1,
 *             fill: '#ddd',
 *             stroke: '#bbb',
 *             lineWidth: 1
 *         }
 *     },
 *     minimum: 0
 * }, {
 *     type: 'category',
 *     position: 'bottom',
 *     title: 'Month of the Year',
 *     grid: true,
 *     label: {
 *         rotate: {
 *             degrees: 315
 *         }
 *     }
 * }]
 * </pre>
 * <p>In this case we use a <code>numeric</code> axis for displaying the values of the Area series and a
 * <code>category</code> axis for displaying the names of the store elements. The numeric axis is placed
 * on the left of the screen, while the category axis is placed at the bottom of the chart.
 * Both the category and numeric axes have <code>→grid</code> set, which means that horizontal and vertical
 * lines will cover the chart background. In the category axis the labels will be rotated so
 * they can fit the space better.</p>
 * @see ext.chart.axis.layout.AxisLayout
 * @see ext.chart.axis.segmenter.AxisSegmenter
 * @see #grid
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html Original Ext JS documentation of 'Ext.chart.axis.Axis'
 */
public class Axis extends Observable {
  /**
   * @inheritDoc
   */
  public function Axis(config:Axis = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Whether to make the auto-calculated minimum and maximum of the axis
   * a multiple of the interval between the major ticks of the axis.
   * If →<code>majorTickSteps</code>, →<code>minimum</code> or →<code>maximum</code>
   * configs have been set, this config will be ignored.
   * Defaults to 'true'.
   * Note: this config has no effect if the axis is →<code>hidden</code>.
   * @default true
   * @see #majorTickSteps
   * @see #minimum
   * @see #maximum
   * @see #hidden
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-adjustByMajorUnit Original Ext JS documentation of 'adjustByMajorUnit'
   * @see #getAdjustByMajorUnit()
   * @see #setAdjustByMajorUnit()
   */
  public native function get adjustByMajorUnit():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set adjustByMajorUnit(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The background config for the axis surface.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-background Original Ext JS documentation of 'background'
   * @see #getBackground()
   * @see #setBackground()
   */
  public native function get background():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set background(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The Chart that the Axis is bound.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-chart Original Ext JS documentation of 'chart'
   * @see #getChart()
   * @see #setChart()
   */
  public native function get chart():AbstractChart;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set chart(value:AbstractChart):void;

  [ExtConfig]
  [Bindable]
  /**
   * An array containing the names of the record fields which should be mapped along the axis.
   * This is optional if the binding between series and fields is clear.
   * @default []
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-fields Original Ext JS documentation of 'fields'
   * @see #getFields()
   * @see #setFields()
   */
  public native function get fields():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set fields(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * If <code>→floating</code> is a number, then it's a percentage displacement of the axis from its
   * initial →<code>position</code> in the direction opposite to the axis' direction. For instance,
   * '{position:"left", floating:75}' displays a vertical axis at 3/4 of the chart, starting
   * from the left. It is equivalent to '{position:"right", floating:25}'. If <code>→floating</code> is
   * an object, then <code>floating.value</code> is the position of this axis along another axis, defined
   * by <code>floating.alongAxis</code>, where <code>alongAxis</code> is an ID, an
   * →<code>ext.chart.AbstractChart.axes</code> config index, or the other axis itself. <code>alongAxis</code>
   * must have an opposite <i>alignment</i> (→<code>ext.chart.axis.Axis.getAlignment()</code>).
   * For example:
   * <pre>
   *  axes: [
   *      {
   *          title: 'Average Temperature (F)',
   *          type: 'numeric',
   *          position: 'left',
   *          id: 'temperature-vertical-axis',
   *          minimum: -30,
   *          maximum: 130
   *      },
   *      {
   *          title: 'Month (2013)',
   *          type: 'category',
   *          position: 'bottom',
   *          floating: {
   *              value: 32,
   *              alongAxis: 'temperature-vertical-axis'
   *          }
   *      }
   *  ]
   * </pre>
   * @default null
   * @see #floating
   * @see #position
   * @see ext.chart.AbstractChart#axes
   * @see ext.chart.axis.Axis#getAlignment()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-floating Original Ext JS documentation of 'floating'
   * @see #getFloating()
   * @see #setFloating()
   */
  public native function get floating():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set floating(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The grid configuration object for the Axis style. Can contain <code>stroke</code> or <code>fill</code>
   * attributes. Also may contain an <code>odd</code> or <code>even</code> property in which you only style things
   * on odd or even rows. For example:
   * <pre>
   * grid {
   *     odd: {
   *         stroke: '#555'
   *     },
   *     even: {
   *         stroke: '#ccc'
   *     }
   * }
   * </pre>
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-grid Original Ext JS documentation of 'grid'
   * @see #getGrid()
   * @see #setGrid()
   */
  public native function get grid():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set grid(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Indicate whether to hide the axis.
   * If the axis is hidden, one of the axis line, ticks, labels or the title will be shown and
   * no margin will be taken.
   * The coordination mechanism works fine no matter if the axis is hidden.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-hidden Original Ext JS documentation of 'hidden'
   * @see #getHidden()
   * @see #setHidden()
   */
  public native function get hidden():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set hidden(value:Boolean):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The <b>unique</b> id of this axis instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-id Original Ext JS documentation of 'id'
   * @see #getId()
   */
  public native function get id():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set id(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The label configuration object for the Axis. This object may include style attributes
   * like <code>spacing</code>, <code>padding</code>, <code>font</code> that receives a string or number and
   * returns a new string with the modified values.
   * <p>For more supported values, see the configurations for →<code>ext.chart.sprite.LabelSprite</code>.</p>
   * @default undefined
   * @see ext.chart.sprite.LabelSprite
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-label Original Ext JS documentation of 'label'
   * @see #getLabel()
   * @see #setLabel()
   */
  public native function get label():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set label(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The axis layout config. See →<code>ext.chart.axis.layout.AxisLayout</code>
   * @default 'continuous'
   * @see ext.chart.axis.layout.AxisLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-layout Original Ext JS documentation of 'layout'
   * @see #getLayout()
   * @see #setLayout()
   */
  public native function get layout():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set layout(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The limit lines configuration for the axis.
   * For example:
   * <pre>
   * limits: [{
   *     value: 50,
   *     line: {
   *         strokeStyle: 'red',
   *         lineDash: [6, 3],
   *         title: {
   *             text: 'Monthly minimum',
   *             fontSize: 14
   *         }
   *     }
   * }]
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-limits Original Ext JS documentation of 'limits'
   * @see #getLimits()
   * @see #setLimits()
   */
  public native function get limits():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set limits(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Axis (itself, its ID or index) that this axis is linked to.
   * When an axis is linked to a master axis, it will use the same data as the master axis.
   * It can be used to show additional info, or to ease reading the chart by duplicating
   * the scales.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-linkedTo Original Ext JS documentation of 'linkedTo'
   * @see #getLinkedTo()
   * @see #setLinkedTo()
   */
  public native function get linkedTo():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set linkedTo(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Forces the number of major ticks to the specified value.
   * Both →<code>minimum</code> and →<code>maximum</code> should be specified.
   * @default 0
   * @see #minimum
   * @see #maximum
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-majorTickSteps Original Ext JS documentation of 'majorTickSteps'
   * @see #getMajorTickSteps()
   * @see #setMajorTickSteps()
   */
  public native function get majorTickSteps():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set majorTickSteps(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The margin of the axis. Used to control the spacing between axes in charts with multiple
   * axes. Unlike CSS where the margin is added on all 4 sides of an element, the <code>→margin</code>
   * is the total space that is added horizontally for a vertical axis, vertically
   * for a horizontal axis, and radially for an angular axis.
   * @default 0
   * @see #margin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-margin Original Ext JS documentation of 'margin'
   * @see #getMargin()
   * @see #setMargin()
   */
  public native function get margin():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set margin(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The maximum zooming level for axis.
   * @default 10000
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-maxZoom Original Ext JS documentation of 'maxZoom'
   * @see #getMaxZoom()
   * @see #setMaxZoom()
   */
  public native function get maxZoom():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set maxZoom(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The maximum value drawn by the axis. If not set explicitly, the axis
   * maximum will be calculated automatically.
   * @default NaN
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-maximum Original Ext JS documentation of 'maximum'
   * @see #getMaximum()
   * @see #setMaximum()
   */
  public native function get maximum():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set maximum(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum zooming level for axis.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-minZoom Original Ext JS documentation of 'minZoom'
   * @see #getMinZoom()
   * @see #setMinZoom()
   */
  public native function get minZoom():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set minZoom(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum value drawn by the axis. If not set explicitly, the axis
   * minimum will be calculated automatically.
   * @default NaN
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-minimum Original Ext JS documentation of 'minimum'
   * @see #getMinimum()
   * @see #setMinimum()
   */
  public native function get minimum():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set minimum(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The number of small ticks between two major ticks.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-minorTickSteps Original Ext JS documentation of 'minorTickSteps'
   * @see #getMinorTickSteps()
   * @see #setMinorTickSteps()
   */
  public native function get minorTickSteps():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set minorTickSteps(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Indicates that the axis needs high precision surface implementation.
   * See →<code>ext.draw.engine.Canvas.highPrecision</code>
   * @default false
   * @see ext.draw.engine.Canvas#highPrecision
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-needHighPrecision Original Ext JS documentation of 'needHighPrecision'
   * @see #getNeedHighPrecision()
   * @see #setNeedHighPrecision()
   */
  public native function get needHighPrecision():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set needHighPrecision(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Where to set the axis. Available options are <code>left</code>, <code>bottom</code>, <code>right</code>, <code>top</code>, <code>radial</code>,
   * and <code>angular</code>.
   * @default 'bottom'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-position Original Ext JS documentation of 'position'
   * @see #getPosition()
   * @see #setPosition()
   */
  public native function get position():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set position(value:String):void;

  [ExtConfig("reconcileRange")]
  [Bindable]
  /**
   * If 'true' the range of the axis will be a union of ranges
   * of all the axes with the same direction. Defaults to 'false'.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-reconcileRange Original Ext JS documentation of 'reconcileRange'
   * @see #getReconcileRange()
   * @see #setReconcileRange()
   */
  public native function get reconcileRange_():Boolean;

  [ExtConfig("reconcileRange")]
  [Bindable]
  /**
   * @private
   */
  public native function set reconcileRange_(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Allows to change the text shown next to the tick.
   * <ul>
   * <li><code>axis:ext.chart.axis.Axis</code> —
   * The axis.
   * </li>
   * <li><code>label</code> —
   * The label.
   * </li>
   * <li><code>layoutContext:Object</code> —
   * The object that holds calculated positions
   * of axis' ticks based on current layout, segmenter, axis length and configuration.
   * </li>
   * <li><code>lastLabel</code> —
   * The last label (if any).
   * </li>
   * <li><code>null:String</code> —
   * The label to display.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-renderer Original Ext JS documentation of 'renderer'
   * @see #getRenderer()
   * @see #setRenderer()
   */
  public native function get renderer():Function;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set renderer(value:Function):void;

  [ExtConfig]
  [Bindable]
  /**
   * The segmenter config. See →<code>ext.chart.axis.segmenter.AxisSegmenter</code>
   * @default 'numeric'
   * @see ext.chart.axis.segmenter.AxisSegmenter
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-segmenter Original Ext JS documentation of 'segmenter'
   * @see #getSegmenter()
   * @see #setSegmenter()
   */
  public native function get segmenter():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set segmenter(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The style for the axis line and ticks.
   * Refer to the →<code>null</code>
   * @see null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-style Original Ext JS documentation of 'style'
   * @see #getStyle()
   * @see #setStyle()
   */
  public native function get style():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set style(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The title for the Axis.
   * If given a String, the 'text' attribute of the title sprite will be set,
   * otherwise the style will be set.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-title Original Ext JS documentation of 'title'
   * @see #getTitle()
   * @see #setTitle()
   */
  public native function get title():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set title(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The margin around the axis title. Unlike CSS where the margin is added on all 4
   * sides of an element, the <code>→titleMargin</code> is the total space that is added horizontally
   * for a vertical title and vertically for an horizontal title, with half the <code>→titleMargin</code>
   * being added on either side.
   * @default 4
   * @see #titleMargin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-titleMargin Original Ext JS documentation of 'titleMargin'
   * @see #getTitleMargin()
   * @see #setTitleMargin()
   */
  public native function get titleMargin():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set titleMargin(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Specify the proportion of the axis to be rendered. The series bound to
   * this axis will be synchronized and transformed accordingly.
   * @default [
   *     0,
   *     1
   * ]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#cfg-visibleRange Original Ext JS documentation of 'visibleRange'
   * @see #getVisibleRange()
   * @see #setVisibleRange()
   */
  public native function get visibleRange():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set visibleRange(value:Array):void;

  /**
   * Returns the value of <code>adjustByMajorUnit</code>.
   * @see #adjustByMajorUnit
   */
  public native function getAdjustByMajorUnit():Boolean;

  /**
   * Returns the value of <code>background</code>.
   * @see #background
   */
  public native function getBackground():Object;

  /**
   * Returns the value of <code>chart</code>.
   * @see #chart
   */
  public native function getChart():AbstractChart;

  /**
   * Mapping data value into coordinate.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#method-getCoordFor Original Ext JS documentation of 'getCoordFor'
   */
  public native function getCoordFor(value:*, field:String, idx:Number = NaN, items:MixedCollection = null):Number;

  /**
   * Returns the value of <code>fields</code>.
   * @see #fields
   */
  public native function getFields():Array;

  /**
   * Returns the value of <code>floating</code>.
   * @see #floating
   */
  public native function getFloating():*;

  /**
   * Returns the value of <code>grid</code>.
   * @see #grid
   */
  public native function getGrid():Object;

  /**
   * Returns the value of <code>hidden</code>.
   * @see #hidden
   */
  public native function getHidden():Boolean;

  /**
   * Returns the value of <code>label</code>.
   * @see #label
   */
  public native function getLabel():Object;

  /**
   * Returns the value of <code>layout</code>.
   * @see #layout
   */
  public native function getLayout():*;

  /**
   * Returns the value of <code>limits</code>.
   * @see #limits
   */
  public native function getLimits():*;

  /**
   * Returns the value of <code>linkedTo</code>.
   * @see #linkedTo
   */
  public native function getLinkedTo():*;

  /**
   * Returns the value of <code>majorTickSteps</code>.
   * @see #majorTickSteps
   */
  public native function getMajorTickSteps():Number;

  /**
   * Returns the value of <code>margin</code>.
   * @see #margin
   */
  public native function getMargin():Number;

  /**
   * Returns the value of <code>maxZoom</code>.
   * @see #maxZoom
   */
  public native function getMaxZoom():Number;

  /**
   * Returns the value of <code>maximum</code>.
   * @see #maximum
   */
  public native function getMaximum():Number;

  /**
   * Returns the value of <code>minZoom</code>.
   * @see #minZoom
   */
  public native function getMinZoom():Number;

  /**
   * Returns the value of <code>minimum</code>.
   * @see #minimum
   */
  public native function getMinimum():Number;

  /**
   * Returns the value of <code>minorTickSteps</code>.
   * @see #minorTickSteps
   */
  public native function getMinorTickSteps():Number;

  /**
   * Returns the value of <code>needHighPrecision</code>.
   * @see #needHighPrecision
   */
  public native function getNeedHighPrecision():Boolean;

  /**
   * Returns the value of <code>position</code>.
   * @see #position
   */
  public native function getPosition():String;

  [ArrayElementType("Number")]
  /**
   * Get the range derived from all the bound series.
   * The range value is cached and returned the next time this method is called.
   * Set <code>recalculate</code> to <code>true</code> to recalculate the range, if changes to the
   * chart, its components or data are expected to affect the range.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#method-getRange Original Ext JS documentation of 'getRange'
   */
  public native function getRange(recalculate:Boolean = false):Array;

  /**
   * Returns the value of <code>reconcileRange_</code>.
   * @see #reconcileRange_
   */
  public native function getReconcileRange():Boolean;

  /**
   * Returns the value of <code>renderer</code>.
   * @see #renderer
   */
  public native function getRenderer():Function;

  /**
   * Returns the value of <code>segmenter</code>.
   * @see #segmenter
   */
  public native function getSegmenter():*;

  /**
   * Returns the value of <code>style</code>.
   * @see #style
   */
  public native function getStyle():Object;

  /**
   * Returns the value of <code>title</code>.
   * @see #title
   */
  public native function getTitle():*;

  /**
   * Returns the value of <code>titleMargin</code>.
   * @see #titleMargin
   */
  public native function getTitleMargin():Number;

  /**
   * Returns the value of <code>visibleRange</code>.
   * @see #visibleRange
   */
  public native function getVisibleRange():Array;

  /**
   * Invoked when data has changed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#method-processData Original Ext JS documentation of 'processData'
   */
  protected native function processData():void;

  /**
   * Expands the range of the axis
   * based on the range of other axes with the same direction (if any).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#method-reconcileRange Original Ext JS documentation of 'reconcileRange'
   */
  public native function reconcileRange():void;

  /**
   * Invokes renderFrame on this axis's surface(s)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis.html#method-renderFrame Original Ext JS documentation of 'renderFrame'
   */
  public native function renderFrame():void;

  /**
   * Sets the value of <code>adjustByMajorUnit</code>.
   * @param adjustByMajorUnit The new value.
   * @see #adjustByMajorUnit
   */
  public native function setAdjustByMajorUnit(adjustByMajorUnit:Boolean):void;

  /**
   * Sets the value of <code>background</code>.
   * @param background The new value.
   * @see #background
   */
  public native function setBackground(background:Object):void;

  /**
   * Sets the value of <code>chart</code>.
   * @param chart The new value.
   * @see #chart
   */
  public native function setChart(chart:AbstractChart):void;

  /**
   * Sets the value of <code>fields</code>.
   * @param fields The new value.
   * @see #fields
   */
  public native function setFields(fields:Array):void;

  /**
   * Sets the value of <code>floating</code>.
   * @param floating The new value.
   * @see #floating
   */
  public native function setFloating(floating:*):void;

  /**
   * Sets the value of <code>grid</code>.
   * @param grid The new value.
   * @see #grid
   */
  public native function setGrid(grid:Object):void;

  /**
   * Sets the value of <code>hidden</code>.
   * @param hidden The new value.
   * @see #hidden
   */
  public native function setHidden(hidden:Boolean):void;

  /**
   * Sets the value of <code>label</code>.
   * @param label The new value.
   * @see #label
   */
  public native function setLabel(label:Object):void;

  /**
   * Sets the value of <code>layout</code>.
   * @param layout The new value.
   * @see #layout
   */
  public native function setLayout(layout:*):void;

  /**
   * Sets the value of <code>limits</code>.
   * @param limits The new value.
   * @see #limits
   */
  public native function setLimits(limits:*):void;

  /**
   * Sets the value of <code>linkedTo</code>.
   * @param linkedTo The new value.
   * @see #linkedTo
   */
  public native function setLinkedTo(linkedTo:*):void;

  /**
   * Sets the value of <code>majorTickSteps</code>.
   * @param majorTickSteps The new value.
   * @see #majorTickSteps
   */
  public native function setMajorTickSteps(majorTickSteps:Number):void;

  /**
   * Sets the value of <code>margin</code>.
   * @param margin The new value.
   * @see #margin
   */
  public native function setMargin(margin:Number):void;

  /**
   * Sets the value of <code>maxZoom</code>.
   * @param maxZoom The new value.
   * @see #maxZoom
   */
  public native function setMaxZoom(maxZoom:Number):void;

  /**
   * Sets the value of <code>maximum</code>.
   * @param maximum The new value.
   * @see #maximum
   */
  public native function setMaximum(maximum:Number):void;

  /**
   * Sets the value of <code>minZoom</code>.
   * @param minZoom The new value.
   * @see #minZoom
   */
  public native function setMinZoom(minZoom:Number):void;

  /**
   * Sets the value of <code>minimum</code>.
   * @param minimum The new value.
   * @see #minimum
   */
  public native function setMinimum(minimum:Number):void;

  /**
   * Sets the value of <code>minorTickSteps</code>.
   * @param minorTickSteps The new value.
   * @see #minorTickSteps
   */
  public native function setMinorTickSteps(minorTickSteps:Number):void;

  /**
   * Sets the value of <code>needHighPrecision</code>.
   * @param needHighPrecision The new value.
   * @see #needHighPrecision
   */
  public native function setNeedHighPrecision(needHighPrecision:Boolean):void;

  /**
   * Sets the value of <code>position</code>.
   * @param position The new value.
   * @see #position
   */
  public native function setPosition(position:String):void;

  /**
   * Sets the value of <code>reconcileRange_</code>.
   * @param reconcileRange_ The new value.
   * @see #reconcileRange_
   */
  public native function setReconcileRange(reconcileRange_:Boolean):void;

  /**
   * Sets the value of <code>renderer</code>.
   * @param renderer The new value.
   * @see #renderer
   */
  public native function setRenderer(renderer:Function):void;

  /**
   * Sets the value of <code>segmenter</code>.
   * @param segmenter The new value.
   * @see #segmenter
   */
  public native function setSegmenter(segmenter:*):void;

  /**
   * Sets the value of <code>style</code>.
   * @param style The new value.
   * @see #style
   */
  public native function setStyle(style:Object):void;

  /**
   * Sets the value of <code>title</code>.
   * @param title The new value.
   * @see #title
   */
  public native function setTitle(title:*):void;

  /**
   * Sets the value of <code>titleMargin</code>.
   * @param titleMargin The new value.
   * @see #titleMargin
   */
  public native function setTitleMargin(titleMargin:Number):void;

  /**
   * Sets the value of <code>visibleRange</code>.
   * @param visibleRange The new value.
   * @see #visibleRange
   */
  public native function setVisibleRange(visibleRange:Array):void;
}
}