package ext.chart.axis {
[Native("Ext.chart.axis.Axis3D", require)]
/**
 * Defines a 3D axis for charts.
 * <p>A 3D axis has the same properties as the regular <i>axis</i> (→<code>ext.chart.axis.Axis</code>),
 * plus a notion of depth. The depth of the 3D axis is determined automatically
 * based on the depth of the bound series.</p>
 * <p>This type of axis has the following limitations compared to the regular axis class:</p>
 * <ul>
 * <li>supported <i>positions</i> (→<code>ext.chart.axis.Axis.position</code>) are 'left' and 'bottom' only;</li>
 * <li>floating axes are not supported.</li>
 * </ul>
 * <p>At the present moment only →<code>ext.chart.series.Bar3DSeries</code> series can make use of the 3D axis.</p>
 * @see ext.chart.axis.Axis
 * @see ext.chart.axis.Axis#position
 * @see ext.chart.series.Bar3DSeries
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis3D.html Original Ext JS documentation of 'Ext.chart.axis.Axis3D'
 */
public class Axis3D extends Axis {
  /**
   * @inheritDoc
   */
  public function Axis3D(config:Axis3D = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Where to set the axis. Available options are <code>left</code> and <code>bottom</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Axis3D.html#cfg-position Original Ext JS documentation of 'position'
   * @see #getPosition()
   * @see #setPosition()
   */
  override public native function get position():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set position(value:String):void;

  /**
   * Returns the value of <code>position</code>.
   * @see #position
   */
  override public native function getPosition():String;

  /**
   * Sets the value of <code>position</code>.
   * @param position The new value.
   * @see #position
   */
  override public native function setPosition(position:String):void;
}
}