package ext.chart.axis {
[Native("Ext.chart.axis.Numeric", require)]
/**
 * An axis to handle numeric values. This axis is used for quantitative data as
 * opposed to the category axis. You can set minimum and maximum values to the
 * axis so that the values are bound to that. If no values are set, then the
 * scale will auto-adjust to the values.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'cartesian',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    store: {
 *        fields: ['name', 'data1', 'data2', 'data3'],
 *        data: [{
 *            'name': 1,
 *            'data1': 10,
 *            'data2': 12,
 *            'data3': 14
 *        }, {
 *            'name': 2,
 *            'data1': 7,
 *            'data2': 8,
 *            'data3': 16
 *        }, {
 *            'name': 3,
 *            'data1': 5,
 *            'data2': 2,
 *            'data3': 14
 *        }, {
 *            'name': 4,
 *            'data1': 2,
 *            'data2': 14,
 *            'data3': 6
 *        }, {
 *            'name': 5,
 *            'data1': 27,
 *            'data2': 38,
 *            'data3': 36
 *        }]
 *    },
 *    axes: {
 *        type: 'numeric',
 *        position: 'left',
 *        minimum: 0,
 *        fields: ['data1', 'data2', 'data3'],
 *        title: 'Sample Values',
 *        grid: {
 *            odd: {
 *                opacity: 1,
 *                fill: '#F2F2F2',
 *                stroke: '#DDD',
 *                'lineWidth': 1
 *            }
 *        }
 *    },
 *    series: {
 *        type: 'area',
 *        subStyle: {
 *            fill: ['#0A3F50', '#30BDA7', '#96D4C6']
 *        },
 *        xField: 'name',
 *        yField: ['data1', 'data2', 'data3']
 *    }
 * });
 * </pre>
 * <p>In this example we create an axis of Numeric type. We set a minimum value so that
 * even if all series have values greater than zero, the grid starts at zero. We bind
 * the axis onto the left part of the surface by setting <i>position</i> to <i>left</i>.
 * We bind three different store fields to this axis by setting <i>fields</i> to an array.
 * We set the title of the axis to <i>Number of Hits</i> by using the <i>title</i> property.
 * We use a <i>grid</i> configuration to set odd background rows to a certain style and even rows
 * to be transparent/ignored.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Numeric.html Original Ext JS documentation of 'Ext.chart.axis.Numeric'
 */
public class AxisNumeric extends Axis {
  /**
   * @inheritDoc
   */
  public function AxisNumeric(config:AxisNumeric = null) {
    super();
  }
}
}