package ext.chart.axis {
[Native("Ext.chart.axis.Time", require)]
/**
 * A type of axis whose units are measured in time values. Use this axis
 * for listing dates that you will want to group or dynamically change.
 * If you just want to display dates as categories then use the
 * Category class for axis instead.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'cartesian',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    store: {
 *        fields: ['time', 'open', 'high', 'low', 'close'],
 *        data: [{
 *            'time': new Date('Jan 1 2010').getTime(),
 *            'open': 600,
 *            'high': 614,
 *            'low': 578,
 *            'close': 590
 *        }, {
 *            'time': new Date('Jan 2 2010').getTime(),
 *            'open': 590,
 *            'high': 609,
 *            'low': 580,
 *            'close': 580
 *        }, {
 *            'time': new Date('Jan 3 2010').getTime(),
 *            'open': 580,
 *            'high': 602,
 *            'low': 578,
 *            'close': 602
 *        }, {
 *            'time': new Date('Jan 4 2010').getTime(),
 *            'open': 602,
 *            'high': 614,
 *            'low': 586,
 *            'close': 586
 *        }]
 *    },
 *    axes: [{
 *        type: 'numeric',
 *        position: 'left',
 *        fields: ['open', 'high', 'low', 'close'],
 *        title: {
 *            text: 'Sample Values',
 *            fontSize: 15
 *        },
 *        grid: true,
 *        minimum: 560,
 *        maximum: 640
 *    }, {
 *        type: 'time',
 *        position: 'bottom',
 *        fields: ['time'],
 *        fromDate: new Date('Dec 31 2009'),
 *        toDate: new Date('Jan 5 2010'),
 *        title: {
 *            text: 'Sample Values',
 *            fontSize: 15
 *        },
 *        style: {
 *            axisLine: false
 *        }
 *    }],
 *    series: {
 *        type: 'candlestick',
 *        xField: 'time',
 *        openField: 'open',
 *        highField: 'high',
 *        lowField: 'low',
 *        closeField: 'close',
 *        style: {
 *            ohlcType: 'ohlc',
 *            dropStyle: {
 *                fill: 'rgb(255, 128, 128)',
 *                stroke: 'rgb(255, 128, 128)',
 *                lineWidth: 3
 *            },
 *            raiseStyle: {
 *                fill: 'rgb(48, 189, 167)',
 *                stroke: 'rgb(48, 189, 167)',
 *                lineWidth: 3
 *            }
 *        }
 *    }
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Time.html Original Ext JS documentation of 'Ext.chart.axis.Time'
 */
public class AxisTime extends AxisNumeric {
  /**
   * @inheritDoc
   */
  public function AxisTime(config:AxisTime = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Indicates the format the date will be rendered in.
   * For example: 'M d' will render the dates as 'Jan 30'.
   * This config works by setting the →<code>renderer</code> config
   * to a function that uses →<code>ext.DateUtil.format()</code> to format the dates
   * using the given <code>→dateFormat</code>.
   * If the →<code>renderer</code> config was set by the user, changes to this config
   * won't replace the user set renderer (until the user removes the renderer by
   * setting the <code>→renderer</code> config to <code>null</code>). In this case the way the <code>→dateFormat</code>
   * is used (if at all) is up to the user.
   * @see #renderer
   * @see ext.SDateUtil#format() ext.DateUtil.format()
   * @see #dateFormat
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Time.html#cfg-dateFormat Original Ext JS documentation of 'dateFormat'
   * @see #getDateFormat()
   * @see #setDateFormat()
   */
  public native function get dateFormat():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set dateFormat(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The starting date for the time axis.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Time.html#cfg-fromDate Original Ext JS documentation of 'fromDate'
   * @see #getFromDate()
   * @see #setFromDate()
   */
  public native function get fromDate():Date;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set fromDate(value:Date):void;

  [ExtConfig]
  [Bindable]
  /**
   * The ending date for the time axis.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Time.html#cfg-toDate Original Ext JS documentation of 'toDate'
   * @see #getToDate()
   * @see #setToDate()
   */
  public native function get toDate():Date;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set toDate(value:Date):void;

  /**
   * Returns the value of <code>dateFormat</code>.
   * @see #dateFormat
   */
  public native function getDateFormat():String;

  /**
   * Returns the value of <code>fromDate</code>.
   * @see #fromDate
   */
  public native function getFromDate():Date;

  /**
   * Returns the value of <code>toDate</code>.
   * @see #toDate
   */
  public native function getToDate():Date;

  /**
   * Sets the value of <code>dateFormat</code>.
   * @param dateFormat The new value.
   * @see #dateFormat
   */
  public native function setDateFormat(dateFormat:String):void;

  /**
   * Sets the value of <code>fromDate</code>.
   * @param fromDate The new value.
   * @see #fromDate
   */
  public native function setFromDate(fromDate:Date):void;

  /**
   * Sets the value of <code>toDate</code>.
   * @param toDate The new value.
   * @see #toDate
   */
  public native function setToDate(toDate:Date):void;
}
}