package ext.chart.axis {
[Native("Ext.chart.axis.Time3D", require)]
/**
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Time3D.html Original Ext JS documentation of 'Ext.chart.axis.Time3D'
 */
public class AxisTime3D extends AxisNumeric3D {
  /**
   * @inheritDoc
   */
  public function AxisTime3D(config:AxisTime3D = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Indicates the format the date will be rendered on.
   * For example: 'M d' will render the dates as 'Jan 30', etc.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Time3D.html#cfg-dateFormat Original Ext JS documentation of 'dateFormat'
   * @see #getDateFormat()
   * @see #setDateFormat()
   */
  public native function get dateFormat():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set dateFormat(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The starting date for the time axis.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Time3D.html#cfg-fromDate Original Ext JS documentation of 'fromDate'
   * @see #getFromDate()
   * @see #setFromDate()
   */
  public native function get fromDate():Date;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set fromDate(value:Date):void;

  [ExtConfig]
  [Bindable]
  /**
   * The ending date for the time axis.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.Time3D.html#cfg-toDate Original Ext JS documentation of 'toDate'
   * @see #getToDate()
   * @see #setToDate()
   */
  public native function get toDate():Date;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set toDate(value:Date):void;

  /**
   * Returns the value of <code>dateFormat</code>.
   * @see #dateFormat
   */
  public native function getDateFormat():*;

  /**
   * Returns the value of <code>fromDate</code>.
   * @see #fromDate
   */
  public native function getFromDate():Date;

  /**
   * Returns the value of <code>toDate</code>.
   * @see #toDate
   */
  public native function getToDate():Date;

  /**
   * Sets the value of <code>dateFormat</code>.
   * @param dateFormat The new value.
   * @see #dateFormat
   */
  public native function setDateFormat(dateFormat:*):void;

  /**
   * Sets the value of <code>fromDate</code>.
   * @param fromDate The new value.
   * @see #fromDate
   */
  public native function setFromDate(fromDate:Date):void;

  /**
   * Sets the value of <code>toDate</code>.
   * @param toDate The new value.
   * @see #toDate
   */
  public native function setToDate(toDate:Date):void;
}
}