package ext.chart.axis.layout {
import ext.chart.axis.Axis;
import ext.chart.series.Series;
import ext.mixin.Observable;

[Native("Ext.chart.axis.layout.Layout", require)]
[ExtConfig]
/**
 * Interface used by Axis to process its data into a meaningful layout.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.layout.Layout.html Original Ext JS documentation of 'Ext.chart.axis.layout.Layout'
 */
public class AxisLayout extends Observable {
  /**
   * @inheritDoc
   */
  public function AxisLayout(config:AxisLayout = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The axis that the Layout is bound.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.layout.Layout.html#cfg-axis Original Ext JS documentation of 'axis'
   * @see #getAxis()
   * @see #setAxis()
   */
  public native function get axis():Axis;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set axis(value:Axis):void;

  /**
   * Calculates the position of tick marks for the axis.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.layout.Layout.html#method-calculateLayout Original Ext JS documentation of 'calculateLayout'
   */
  public native function calculateLayout(context:Object):*;

  /**
   * Calculates the position of major ticks for the axis.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.layout.Layout.html#method-calculateMajorTicks Original Ext JS documentation of 'calculateMajorTicks'
   */
  public native function calculateMajorTicks(context:Object):void;

  /**
   * Calculates the position of sub ticks for the axis.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.layout.Layout.html#method-calculateMinorTicks Original Ext JS documentation of 'calculateMinorTicks'
   */
  public native function calculateMinorTicks(context:Object):void;

  /**
   * Returns the value of <code>axis</code>.
   * @see #axis
   */
  public native function getAxis():Axis;

  /**
   * Processes the data of the series bound to the axis.
   * @param series The bound series.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.layout.Layout.html#method-processData Original Ext JS documentation of 'processData'
   */
  public native function processData(series:Series):void;

  /**
   * Sets the value of <code>axis</code>.
   * @param axis The new value.
   * @see #axis
   */
  public native function setAxis(axis:Axis):void;

  /**
   * Snaps the data bound to the axis to meaningful tick marks.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.layout.Layout.html#method-snapEnds Original Ext JS documentation of 'snapEnds'
   */
  public native function snapEnds(context:Object, min:Number, max:Number, estStepSize:Number):void;

  /**
   * Trims the layout of the axis by the defined minimum and maximum.
   * @param context
   * @param ticks Ticks object (e.g. major ticks) to be modified.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.layout.Layout.html#method-trimByRange Original Ext JS documentation of 'trimByRange'
   */
  public native function trimByRange(context:Object, ticks:Object, trimMin:Number, trimMax:Number):void;
}
}