package ext.chart.axis.layout {
[Native("Ext.chart.axis.layout.CombineByIndex", require)]
/**
 * Discrete layout that combines duplicate data points only if they have the same index.
 * For example:
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *     xtype: 'cartesian',
 *     title: 'Weight vs Calories',
 *
 *     renderTo: document.body,
 *     width: 400,
 *     height: 400,
 *
 *     store: {
 *          fields: ['month', 'weight', 'calories'],
 *          data: [
 *              {
 *                  month: 'Jan',
 *                  weight: 185,
 *                  calories: 2650
 *              },
 *              {
 *                  month: 'Jan',
 *                  weight: 188,
 *                  calories: 2800
 *              },
 *              {
 *                  month: 'Feb',
 *                  weight: 188,
 *                  calories: 2800
 *              },
 *              {
 *                  month: 'Mar',
 *                  weight: 191,
 *                  calories: 2800
 *              },
 *              {
 *                  month: 'Apr',
 *                  weight: 189,
 *                  calories: 1500
 *              },
 *              {
 *                  month: 'May',
 *                  weight: 187,
 *                  calories: 1350
 *              }
 *          ]
 *     },
 *
 *     axes: [{
 *         type: 'numeric',
 *         position: 'left',
 *         fields: ['weight'],
 *         minimum: 140
 *     }, {
 *         type: 'numeric',
 *         position: 'right',
 *         fields: ['calories'],
 *         minimum: 500,
 *         maximum: 3500
 *     }, {
 *         type: 'category',
 *         grid: true,
 *         layout: 'combineByIndex',
 *         fields: 'month',
 *         position: 'bottom',
 *         label: {
 *             rotate: {
 *                 degrees: -45
 *             }
 *         }
 *     }],
 *
 *     series: [{
 *         type: 'line',
 *         title: 'Weight',
 *         xField: 'month',
 *         yField: 'weight',
 *         smooth: true,
 *         marker: true
 *     }, {
 *         type: 'line',
 *         title: 'Calories',
 *         xField: 'month',
 *         yField: 'calories',
 *         smooth: true,
 *         marker: true
 *     }],
 *
 *     legend: {
 *         docked: 'bottom'
 *     }
 *
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.layout.CombineByIndex.html Original Ext JS documentation of 'Ext.chart.axis.layout.CombineByIndex'
 */
public class CombineByIndexAxisLayout extends DiscreteAxisLayout {
  /**
   * @inheritDoc
   */
  public function CombineByIndexAxisLayout(config:CombineByIndexAxisLayout = null) {
    super();
  }
}
}