package ext.chart.axis.layout {
[Native("Ext.chart.axis.layout.Discrete", require)]
/**
 * Simple processor for data that cannot be interpolated.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.layout.Discrete.html Original Ext JS documentation of 'Ext.chart.axis.layout.Discrete'
 */
public class DiscreteAxisLayout extends AxisLayout {
  /**
   * @inheritDoc
   */
  public function DiscreteAxisLayout(config:DiscreteAxisLayout = null) {
    super();
  }

  /**
   * Calculates the position of tick marks for the axis.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.layout.Discrete.html#method-calculateLayout Original Ext JS documentation of 'calculateLayout'
   */
  override public native function calculateLayout(context:Object):*;

  /**
   * Calculates the position of major ticks for the axis.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.layout.Discrete.html#method-calculateMajorTicks Original Ext JS documentation of 'calculateMajorTicks'
   */
  override public native function calculateMajorTicks(context:Object):void;

  /**
   * Snaps the data bound to the axis to meaningful tick marks.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.layout.Discrete.html#method-snapEnds Original Ext JS documentation of 'snapEnds'
   */
  override public native function snapEnds(context:Object, min:Number, max:Number, estStepSize:Number):void;

  /**
   * Trims the layout of the axis by the defined minimum and maximum.
   * @param context
   * @param ticks Ticks object (e.g. major ticks) to be modified.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.layout.Discrete.html#method-trimByRange Original Ext JS documentation of 'trimByRange'
   */
  override public native function trimByRange(context:Object, ticks:Object, trimMin:Number, trimMax:Number):void;
}
}