package ext.chart.axis.segmenter {
import ext.Base;
import ext.chart.axis.Axis;

[Native("Ext.chart.axis.segmenter.Segmenter", require)]
[ExtConfig]
/**
 * Interface for a segmenter in an Axis. A segmenter defines the operations you can do to a specific
 * data type.
 * <p>See →<code>ext.chart.axis.Axis</code>.</p>
 * @see ext.chart.axis.Axis
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.segmenter.Segmenter.html Original Ext JS documentation of 'Ext.chart.axis.segmenter.Segmenter'
 */
public class AxisSegmenter extends Base {

  public function AxisSegmenter(config:AxisSegmenter) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The axis that the Segmenter is bound.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.segmenter.Segmenter.html#cfg-axis Original Ext JS documentation of 'axis'
   * @see #getAxis()
   * @see #setAxis()
   */
  public native function get axis():Axis;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set axis(value:Axis):void;

  /**
   * Add <code>step</code> <code>unit</code>s to the value.
   * @param value The value to be added.
   * @param step The step of units. Negative value are allowed.
   * @param unit The unit.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.segmenter.Segmenter.html#method-add Original Ext JS documentation of 'add'
   */
  public native function add(value:*, step:Number, unit:*):void;

  /**
   * Align value with step of units.
   * For example, for the date segmenter, if the unit is "Month" and step is 3, the value will be
   * aligned by seasons.
   * @param value The value to be aligned.
   * @param step The step of units.
   * @param unit The unit.
   * @return Aligned value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.segmenter.Segmenter.html#method-align Original Ext JS documentation of 'align'
   */
  public native function align(value:*, step:Number, unit:*):*;

  /**
   * Returns the difference between the min and max value based on the given unit scale.
   * @param min The smaller value.
   * @param max The larger value.
   * @param unit The unit scale. Unit can be any type.
   * @return The number of <code>unit</code>s between min and max. It is the minimum n that
   * min + n &#42; unit &gt;= max.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.segmenter.Segmenter.html#method-diff Original Ext JS documentation of 'diff'
   */
  public native function diff(min:*, max:*, unit:*):Number;

  /**
   * Convert from any data into the target type.
   * @param value The value to convert from
   * @return The converted value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.segmenter.Segmenter.html#method-from Original Ext JS documentation of 'from'
   */
  public native function from(value:*):*;

  /**
   * Returns the value of <code>axis</code>.
   * @see #axis
   */
  public native function getAxis():Axis;

  /**
   * Given a start point and estimated step size of a range, determine the preferred step size.
   * @param start The start point of range.
   * @param estStepSize The estimated step size.
   * @return Return the step size by an object of step x unit.
   * <ul>
   * <li><code>step:Number</code> (optional) —
   * The step count of units.
   * </li>
   * <li><code>unit</code> (optional) —
   * The unit.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.segmenter.Segmenter.html#method-preferredStep Original Ext JS documentation of 'preferredStep'
   */
  public native function preferredStep(start:*, estStepSize:*):Object;

  /**
   * This method formats the value.
   * @param value The value to format.
   * @param context Axis layout context.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.segmenter.Segmenter.html#method-renderer Original Ext JS documentation of 'renderer'
   */
  public native function renderer(value:*, context:Object):String;

  /**
   * Sets the value of <code>axis</code>.
   * @param axis The new value.
   * @see #axis
   */
  public native function setAxis(axis:Axis):void;
}
}