package ext.chart.axis.segmenter {

[Native("Ext.chart.axis.segmenter.Numeric", require)]
/**
 * Numeric data type.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.segmenter.Numeric.html Original Ext JS documentation of 'Ext.chart.axis.segmenter.Numeric'
 */
public class AxisSegmenterNumeric extends AxisSegmenter {

  public function AxisSegmenterNumeric(config:AxisSegmenterNumeric) {
    super(config);
  }

  /**
   * Wraps the provided estimated step size of a range without altering it into a step size
   * object.
   * @param min The start point of range.
   * @param estStepSize The estimated step size.
   * @return Return the step size by an object of step x unit.
   * <ul>
   * <li><code>step:Number</code> (optional) —
   * The step count of units.
   * </li>
   * <li><code>unit:Object</code> (optional) —
   * The unit.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.segmenter.Numeric.html#method-exactStep Original Ext JS documentation of 'exactStep'
   */
  public native function exactStep(min:*, estStepSize:*):Object;
}
}