package ext.chart.axis.segmenter {

[Native("Ext.chart.axis.segmenter.Time", require)]
/**
 * Time data type.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.segmenter.Time.html Original Ext JS documentation of 'Ext.chart.axis.segmenter.Time'
 */
public class AxisSegmenterTime extends AxisSegmenter {

  public function AxisSegmenterTime(config:AxisSegmenterTime) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * <ul>
   * <li><code>unit:String</code> (optional) —
   * The unit of the step (Ext.Date.DAY, Ext.Date.MONTH, etc).
   * </li>
   * <li><code>step:Number</code> (optional) —
   * The number of units for the step (1, 2, etc).
   * If specified, will override the result of →<code>preferredStep()</code>.
   * For example:
   * <pre>
   * step: {
   *     unit: Ext.Date.HOUR,
   *     step: 1
   * }
   * </pre>
   * </li>
   * </ul>
   * @see #preferredStep()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.axis.segmenter.Time.html#cfg-step Original Ext JS documentation of 'step'
   * @see #getStep()
   * @see #setStep()
   */
  public native function get step():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set step(value:Object):void;

  /**
   * Returns the value of <code>step</code>.
   * @see #step
   */
  public native function getStep():Object;

  /**
   * Sets the value of <code>step</code>.
   * @param step The new value.
   * @see #step
   */
  public native function setStep(step:Object):void;
}
}