package ext.chart.events {
import ext.chart.AbstractChart;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.chart.events.AbstractChartEvent")]
public class AbstractChartEvent extends FlExtEvent {
  /**
   * Fires before a refresh to the chart data is called. If the <code>→event:onBeforeRefresh</code>
   * handler returns <code>false</code> the →<code>event:onRefresh</code> action will be canceled.
   * @see ext.chart.AbstractChart#event:onBeforeRefresh
   * @see ext.chart.AbstractChart#event:onRefresh
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#event-beforerefresh Original Ext JS documentation of 'beforerefresh'
   * @see ext.chart.AbstractChart
   * @eventType onBeforeRefresh
   */
  public static const BEFORE_REFRESH:String = "onBeforeRefresh";
  /**
   * Fires after each →<code>event:onRedraw</code> call.
   * @see ext.chart.AbstractChart#event:onRedraw
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#event-redraw Original Ext JS documentation of 'redraw'
   * @see ext.chart.AbstractChart
   * @eventType onRedraw
   */
  public static const REDRAW:String = "onRedraw";
  /**
   * Fires after the chart data has been refreshed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#event-refresh Original Ext JS documentation of 'refresh'
   * @see ext.chart.AbstractChart
   * @eventType onRefresh
   */
  public static const REFRESH:String = "onRefresh";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "eOpts"];

  public function AbstractChartEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  public native function get source():AbstractChart;
}
}