package ext.chart.events {
import ext.chart.AbstractChart;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.chart.events.AbstractChart_newItem_oldItemEvent")]
public class AbstractChart_newItem_oldItemEvent extends FlExtEvent {
  /**
   * Fires when an item is highlighted.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#event-itemhighlight Original Ext JS documentation of 'itemhighlight'
   * @see ext.chart.AbstractChart
   * @eventType onItemHighlight
   */
  public static const ITEM_HIGHLIGHT:String = "onItemHighlight";
  /**
   * Fires when an item's highlight changes.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#event-itemhighlightchange Original Ext JS documentation of 'itemhighlightchange'
   * @see ext.chart.AbstractChart
   * @eventType onItemHighlightChange
   */
  public static const ITEM_HIGHLIGHT_CHANGE:String = "onItemHighlightChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "newItem", "oldItem", "eOpts"];

  public function AbstractChart_newItem_oldItemEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The new highlight item.
   */
  public native function get newItem():Object;

  /**
   * The old highlight item.
   */
  public native function get oldItem():Object;

  public native function get source():AbstractChart;
}
}