package ext.chart.interactions {
import ext.chart.AbstractChart;
import ext.mixin.Observable;

import js.Event;

[Native("Ext.chart.interactions.Abstract", require)]
[ExtConfig]
/**
 * Defines a common abstract parent class for all interactions.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.Abstract.html Original Ext JS documentation of 'Ext.chart.interactions.Abstract'
 */
public class AbstractInteraction extends Observable {
  /**
   * @inheritDoc
   */
  public function AbstractInteraction(config:AbstractInteraction = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The chart that the interaction is bound.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.Abstract.html#cfg-chart Original Ext JS documentation of 'chart'
   * @see #getChart()
   * @see #setChart()
   */
  public native function get chart():AbstractChart;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set chart(value:AbstractChart):void;

  [ExtConfig]
  [Bindable]
  /**
   * 'true' if the interaction is enabled.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.Abstract.html#cfg-enabled Original Ext JS documentation of 'enabled'
   * @see #getEnabled()
   * @see #setEnabled()
   */
  public native function get enabled():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set enabled(value:Boolean):void;

  /**
   * Android device is emerging too many events so if we re-render every frame it will
   * take forever to finish a frame.
   * This throttle technique will limit the timespan between two frames.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.Abstract.html#property-throttleGap Original Ext JS documentation of 'throttleGap'
   */
  public native function get throttleGap():*;

  /**
   * @private
   */
  public native function set throttleGap(value:*):void;

  /**
   * Returns the value of <code>chart</code>.
   * @see #chart
   */
  public native function getChart():AbstractChart;

  /**
   * Returns the value of <code>enabled</code>.
   * @see #enabled
   */
  public native function getEnabled():Boolean;

  /**
   * Find and return a single series item corresponding to the given event,
   * or null if no matching item is found.
   * @return the item object or null if none found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.Abstract.html#method-getItemForEvent Original Ext JS documentation of 'getItemForEvent'
   */
  protected native function getItemForEvent(e:Event):Object;

  /**
   * Placeholder method.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.Abstract.html#method-onGesture Original Ext JS documentation of 'onGesture'
   */
  protected native function onGesture():void;

  /**
   * Sets the value of <code>chart</code>.
   * @param chart The new value.
   * @see #chart
   */
  public native function setChart(chart:AbstractChart):void;

  /**
   * Sets the value of <code>enabled</code>.
   * @param enabled The new value.
   * @see #enabled
   */
  public native function setEnabled(enabled:Boolean):void;
}
}