package ext.chart.interactions {
[Native("Ext.chart.interactions.CrossZoom", require)]
/**
 * The CrossZoom interaction allows the user to zoom in on a selected area of the chart.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *     xtype: 'cartesian',
 *     renderTo: Ext.getBody(),
 *     width: 600,
 *     height: 400,
 *     insetPadding: 40,
 *     interactions: 'crosszoom',
 *     store: {
 *         fields: ['name', 'data1', 'data2', 'data3', 'data4', 'data5'],
 *         data: [{
 *             'name': 'metric one',
 *             'data1': 10,
 *             'data2': 12,
 *             'data3': 14,
 *             'data4': 8,
 *             'data5': 13
 *         }, {
 *             'name': 'metric two',
 *             'data1': 7,
 *             'data2': 8,
 *             'data3': 16,
 *             'data4': 10,
 *             'data5': 3
 *         }, {
 *             'name': 'metric three',
 *             'data1': 5,
 *             'data2': 2,
 *             'data3': 14,
 *             'data4': 12,
 *             'data5': 7
 *         }, {
 *             'name': 'metric four',
 *             'data1': 2,
 *             'data2': 14,
 *             'data3': 6,
 *             'data4': 1,
 *             'data5': 23
 *         }, {
 *             'name': 'metric five',
 *             'data1': 27,
 *             'data2': 38,
 *             'data3': 36,
 *             'data4': 13,
 *             'data5': 33
 *         }]
 *     },
 *     axes: [{
 *         type: 'numeric',
 *         position: 'left',
 *         fields: ['data1'],
 *         title: {
 *             text: 'Sample Values',
 *             fontSize: 15
 *         },
 *         grid: true,
 *         minimum: 0
 *     }, {
 *         type: 'category',
 *         position: 'bottom',
 *         fields: ['name'],
 *         title: {
 *             text: 'Sample Values',
 *             fontSize: 15
 *         }
 *     }],
 *     series: [{
 *         type: 'line',
 *         highlight: {
 *             size: 7,
 *             radius: 7
 *         },
 *         style: {
 *             stroke: 'rgb(143,203,203)'
 *         },
 *         xField: 'name',
 *         yField: 'data1',
 *         marker: {
 *             type: 'path',
 *             path: ['M', - 2, 0, 0, 2, 2, 0, 0, - 2, 'Z'],
 *             stroke: 'blue',
 *             lineWidth: 0
 *         }
 *     }, {
 *         type: 'line',
 *         highlight: {
 *             size: 7,
 *             radius: 7
 *         },
 *         fill: true,
 *         xField: 'name',
 *         yField: 'data3',
 *         marker: {
 *             type: 'circle',
 *             radius: 4,
 *             lineWidth: 0
 *         }
 *     }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.CrossZoom.html Original Ext JS documentation of 'Ext.chart.interactions.CrossZoom'
 */
public class CrossZoomInteraction extends AbstractInteraction {
  /**
   * @inheritDoc
   */
  public function CrossZoomInteraction(config:CrossZoomInteraction = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Specifies which axes should be made navigable. The config value can take the following
   * formats:
   * <ul>
   * <li>
   * <p>An Object whose keys correspond to the →<code>ext.chart.axis.Axis.position</code>
   * of each axis that should be made navigable. Each key's value can either be an Object
   * with further configuration options for each axis or simply <code>true</code> for a default
   * set of options.
   * {
   * type: 'crosszoom',
   * axes: {
   * left: {
   * maxZoom: 5,
   * allowPan: false
   * },
   * bottom: true
   * }
   * }</p>
   * <p>If using the full Object form, the following options can be specified for each axis:</p>
   * <ul>
   * <li>minZoom (Number) A minimum zoom level for the axis. Defaults to <code>1</code> which is its
   * natural size.</li>
   * <li>maxZoom (Number) A maximum zoom level for the axis. Defaults to <code>10</code>.</li>
   * <li>startZoom (Number) A starting zoom level for the axis. Defaults to <code>1</code>.</li>
   * <li>allowZoom (Boolean) Whether zooming is allowed for the axis. Defaults to <code>true</code>.</li>
   * <li>allowPan (Boolean) Whether panning is allowed for the axis. Defaults to <code>true</code>.</li>
   * <li>startPan (Boolean) A starting panning offset for the axis. Defaults to <code>0</code>.</li>
   * </ul>
   * </li>
   * <li>
   * <p>An Array of strings, each one corresponding to the
   * →<code>ext.chart.axis.Axis.position</code> of an axis that should be made navigable.
   * The default options will be used for each named axis.</p>
   * <pre>
   * {
   *     type: 'crosszoom',
   *     axes: ['left', 'bottom']
   * }
   * </pre>
   * </li>
   * </ul>
   * <p>If the <code>→axes</code> config is not specified, it will default to making all axes navigable
   * with the default axis options.</p>
   * @default true
   * @see ext.chart.axis.Axis#position
   * @see #axes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.CrossZoom.html#cfg-axes Original Ext JS documentation of 'axes'
   * @see #getAxes()
   * @see #setAxes()
   */
  public native function get axes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set axes(value:*):void;

  /**
   * Returns the value of <code>axes</code>.
   * @see #axes
   */
  public native function getAxes():*;

  /**
   * Sets the value of <code>axes</code>.
   * @param axes The new value.
   * @see #axes
   */
  public native function setAxes(axes:*):void;
}
}