package ext.chart.interactions {
[Native("Ext.chart.interactions.Crosshair", require)]
/**
 * The Crosshair interaction allows the user to get precise values for a specific point
 * on the chart. The values are obtained by single-touch dragging on the chart.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.Container', {
 *     renderTo: Ext.getBody(),
 *     width: 600,
 *     height: 400,
 *     layout: 'fit',
 *     items: {
 *         xtype: 'cartesian',
 *         innerPadding: 20,
 *         interactions: {
 *             type: 'crosshair',
 *             axes: {
 *                 left: {
 *                     label: {
 *                         fillStyle: 'white'
 *                     },
 *                     rect: {
 *                         fillStyle: 'brown',
 *                         radius: 6
 *                     }
 *                 },
 *                 bottom: {
 *                     label: {
 *                         fontSize: '14px',
 *                         fontWeight: 'bold'
 *                     }
 *                 }
 *             },
 *             lines: {
 *                 horizontal: {
 *                     strokeStyle: 'brown',
 *                     lineWidth: 2,
 *                     lineDash: [20, 2, 2, 2, 2, 2, 2, 2]
 *                 }
 *             }
 *         },
 *         store: {
 *             fields: ['name', 'data'],
 *             data: [
 *                 {name: 'apple', data: 300},
 *                 {name: 'orange', data: 900},
 *                 {name: 'banana', data: 800},
 *                 {name: 'pear', data: 400},
 *                 {name: 'grape', data: 500}
 *             ]
 *         },
 *         axes: [{
 *             type: 'numeric',
 *             position: 'left',
 *             fields: ['data'],
 *             title: {
 *                 text: 'Value',
 *                 fontSize: 15
 *             },
 *             grid: true,
 *             label: {
 *                 rotationRads: -Math.PI / 4
 *             }
 *         }, {
 *             type: 'category',
 *             position: 'bottom',
 *             fields: ['name'],
 *             title: {
 *                 text: 'Category',
 *                 fontSize: 15
 *             }
 *         }],
 *         series: {
 *             type: 'line',
 *             style: {
 *                 strokeStyle: 'black'
 *             },
 *             xField: 'name',
 *             yField: 'data',
 *             marker: {
 *                 type: 'circle',
 *                 radius: 5,
 *                 fillStyle: 'lightblue'
 *             }
 *         }
 *     }
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.Crosshair.html Original Ext JS documentation of 'Ext.chart.interactions.Crosshair'
 */
public class CrosshairInteraction extends AbstractInteraction {
  /**
   * @inheritDoc
   */
  public function CrosshairInteraction(config:CrosshairInteraction = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Specifies label text and label rect configs on per axis basis or as a single config
   * for all axes.
   * <pre>
   * {
   *     type: 'crosshair',
   *     axes: {
   *         label: { fillStyle: 'white' },
   *         rect: { fillStyle: 'maroon'}
   *     }
   * }
   * </pre>
   * <p>In case per axis configuration is used, an object with keys corresponding
   * to the →<code>ext.chart.axis.Axis.position</code> must be provided.</p>
   * <pre>
   * {
   *     type: 'crosshair',
   *     axes: {
   *         left: {
   *             label: { fillStyle: 'white' },
   *             rect: {
   *                 fillStyle: 'maroon',
   *                 radius: 4
   *             }
   *         },
   *         bottom: {
   *             label: {
   *                 fontSize: '14px',
   *                 fontWeight: 'bold'
   *             },
   *             rect: { fillStyle: 'white' }
   *         }
   *     }
   * </pre>
   * <p>If the <code>→axes</code> config is not specified, the following defaults will be used:</p>
   * <ul>
   * <li><code>label</code> will use values from the →<code>ext.chart.axis.Axis.label</code> config.</li>
   * <li><code>rect</code> will use the 'white' fillStyle.</li>
   * </ul>
   * @default {
   *     top: {
   *         label: {},
   *         rect: {}
   *     },
   *     right: {
   *         label: {},
   *         rect: {}
   *     },
   *     bottom: {
   *         label: {},
   *         rect: {}
   *     },
   *     left: {
   *         label: {},
   *         rect: {}
   *     }
   * }
   * @see ext.chart.axis.Axis#position
   * @see #axes
   * @see ext.chart.axis.Axis#label
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.Crosshair.html#cfg-axes Original Ext JS documentation of 'axes'
   * @see #getAxes()
   * @see #setAxes()
   */
  public native function get axes():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set axes(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Specifies which gesture should be used for starting/maintaining/ending the interaction.
   * @default 'drag'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.Crosshair.html#cfg-gesture Original Ext JS documentation of 'gesture'
   * @see #getGesture()
   * @see #setGesture()
   */
  public native function get gesture():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set gesture(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Specifies attributes of horizontal and vertical lines that make up the crosshair.
   * If this config is missing, black dashed lines will be used.
   * <pre>
   * {
   *     horizontal: {
   *         strokeStyle: 'red',
   *         lineDash: [] // solid line
   *     },
   *     vertical: {
   *         lineWidth: 2,
   *         lineDash: [15, 5, 5, 5]
   *     }
   * }
   * </pre>
   * @default {
   *     horizontal: {
   *         strokeStyle: 'black',
   *         lineDash: [
   *             5,
   *             5
   *         ]
   *     },
   *     vertical: {
   *         strokeStyle: 'black',
   *         lineDash: [
   *             5,
   *             5
   *         ]
   *     }
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.Crosshair.html#cfg-lines Original Ext JS documentation of 'lines'
   * @see #getLines()
   * @see #setLines()
   */
  public native function get lines():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set lines(value:Object):void;

  /**
   * Returns the value of <code>axes</code>.
   * @see #axes
   */
  public native function getAxes():Object;

  /**
   * Returns the value of <code>gesture</code>.
   * @see #gesture
   */
  public native function getGesture():String;

  /**
   * Returns the value of <code>lines</code>.
   * @see #lines
   */
  public native function getLines():Object;

  /**
   * Sets the value of <code>axes</code>.
   * @param axes The new value.
   * @see #axes
   */
  public native function setAxes(axes:Object):void;

  /**
   * Sets the value of <code>gesture</code>.
   * @param gesture The new value.
   * @see #gesture
   */
  public native function setGesture(gesture:String):void;

  /**
   * Sets the value of <code>lines</code>.
   * @param lines The new value.
   * @see #lines
   */
  public native function setLines(lines:Object):void;
}
}