package ext.chart.interactions {
[Native("Ext.chart.interactions.ItemEdit", require)]
/**
 * @see ext.chart.interactions.events.ItemEditInteraction_chart_interaction_itemEvent.BEGIN_ITEM_EDIT
 * @eventType ext.chart.interactions.events.ItemEditInteraction_chart_interaction_itemEvent.BEGIN_ITEM_EDIT
 */
[Event(name='onBeginItemEdit', type='ext.chart.interactions.events.ItemEditInteraction_chart_interaction_itemEvent')]
/**
 * @see ext.chart.interactions.events.ItemEditInteraction_chart_interaction_item_targetEvent.END_ITEM_EDIT
 * @eventType ext.chart.interactions.events.ItemEditInteraction_chart_interaction_item_targetEvent.END_ITEM_EDIT
 */
[Event(name='onEndItemEdit', type='ext.chart.interactions.events.ItemEditInteraction_chart_interaction_item_targetEvent')]
/**
 * The 'itemedit' interaction allows the user to edit store data
 * by dragging series items in the chart.
 * <p>The 'itemedit' interaction extends the
 * <i>'itemhighlight'</i> (→<code>ext.chart.interactions.ItemHighlightInteraction</code>) interaction,
 * so it also acts like one. If you need both interactions in a single chart,
 * 'itemedit' should be sufficient. Hovering/tapping will result in highlighting,
 * and dragging will result in editing.</p>
 * @see ext.chart.interactions.ItemHighlightInteraction
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.ItemEdit.html Original Ext JS documentation of 'Ext.chart.interactions.ItemEdit'
 */
public class ItemEditInteraction extends ItemHighlightInteraction {
  /**
   * @inheritDoc
   */
  public function ItemEditInteraction(config:ItemEditInteraction = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * A function that returns style attributes for the item that's being dragged.
   * This is useful if you want to give a visual feedback to the user when
   * they dragged to a certain point.
   * @default null
   * <ul>
   * <li><code>data:Object</code> —
   * The following properties are available:
   * <ul>
   * <li><code>target:Object</code> (optional) —
   * The object containing the xField/xValue or/and
   * yField/yValue properties, where the xField/yField specify the store records
   * being edited and the xValue/yValue the target values to be set when
   * the interaction ends. The object also contains the 'index' of the record
   * being edited.
   * </li>
   * <li><code>style:Object</code> (optional) —
   * The style that is going to be used for the dragged item.
   * The attributes returned by the renderer will be applied on top of this style.
   * </li>
   * <li><code>item:Object</code> (optional) —
   * The series item being dragged.
   * This is actually the →<code>ext.chart.AbstractChart.highlightItem</code>.
   * </li>
   * </ul>
   * </li>
   * <li><code>null:Object</code> —
   * The style attributes to be set on the dragged item.
   * </li>
   * </ul>
   * @see ext.chart.AbstractChart#highlightItem
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.ItemEdit.html#cfg-renderer Original Ext JS documentation of 'renderer'
   * @see #getRenderer()
   * @see #setRenderer()
   */
  public native function get renderer():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set renderer(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The style that will be applied to the series item on dragging.
   * By default, series item will have no fill,
   * and will have a dashed stroke of the same color.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.ItemEdit.html#cfg-style Original Ext JS documentation of 'style'
   * @see #getStyle()
   * @see #setStyle()
   */
  public native function get style():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set style(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.ItemEdit.html#cfg-tooltip Original Ext JS documentation of 'tooltip'
   * @see #getTooltip()
   * @see #setTooltip()
   */
  public native function get tooltip():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set tooltip(value:*):void;

  /**
   * Returns the value of <code>renderer</code>.
   * @see #renderer
   */
  public native function getRenderer():*;

  /**
   * Returns the value of <code>style</code>.
   * @see #style
   */
  public native function getStyle():Object;

  /**
   * Returns the value of <code>tooltip</code>.
   * @see #tooltip
   */
  public native function getTooltip():*;

  /**
   * Sets the value of <code>renderer</code>.
   * @param renderer The new value.
   * @see #renderer
   */
  public native function setRenderer(renderer:*):void;

  /**
   * Sets the value of <code>style</code>.
   * @param style The new value.
   * @see #style
   */
  public native function setStyle(style:Object):void;

  /**
   * Sets the value of <code>tooltip</code>.
   * @param tooltip The new value.
   * @see #tooltip
   */
  public native function setTooltip(tooltip:*):void;
}
}