package ext.chart.interactions {
[Native("Ext.chart.interactions.ItemHighlight", require)]
/**
 * The 'itemhighlight' interaction allows the user to highlight series items in the chart.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.ItemHighlight.html Original Ext JS documentation of 'Ext.chart.interactions.ItemHighlight'
 */
public class ItemHighlightInteraction extends AbstractInteraction {
  /**
   * @inheritDoc
   */
  public function ItemHighlightInteraction(config:ItemHighlightInteraction = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Enable displaying multiple tooltips for overlapping or adjacent series items within
   * →<code>ext.chart.series.LineSeries.selectionTolerance</code> radius.
   * Default is to display a tooltip only for the last series item rendered.
   * When multiple tooltips are displayed, they may overlap partially or completely;
   * it is up to the developer to ensure tooltip positioning is satisfactory.
   * @default false
   * @since 6.6.0
   * @see ext.chart.series.LineSeries#selectionTolerance
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.ItemHighlight.html#cfg-multiTooltips Original Ext JS documentation of 'multiTooltips'
   * @see #getMultiTooltips()
   * @see #setMultiTooltips()
   */
  public native function get multiTooltips():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set multiTooltips(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Disables mouse tracking.
   * Series items will only be highlighted/unhighlighted on mouse click.
   * This config has no effect on touch devices.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.ItemHighlight.html#cfg-sticky Original Ext JS documentation of 'sticky'
   * @see #getSticky()
   * @see #setSticky()
   */
  public native function get sticky():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set sticky(value:Boolean):void;

  /**
   * Returns the value of <code>multiTooltips</code>.
   * @see #multiTooltips
   */
  public native function getMultiTooltips():Boolean;

  /**
   * Returns the value of <code>sticky</code>.
   * @see #sticky
   */
  public native function getSticky():Boolean;

  /**
   * Sets the value of <code>multiTooltips</code>.
   * @param multiTooltips The new value.
   * @see #multiTooltips
   */
  public native function setMultiTooltips(multiTooltips:Boolean):void;

  /**
   * Sets the value of <code>sticky</code>.
   * @param sticky The new value.
   * @see #sticky
   */
  public native function setSticky(sticky:Boolean):void;
}
}