package ext.chart.interactions {
[Native("Ext.chart.interactions.ItemInfo", require)]
/**
 * @see ext.chart.interactions.events.ItemInfoInteraction_item_panelEvent.SHOW
 * @eventType ext.chart.interactions.events.ItemInfoInteraction_item_panelEvent.SHOW
 */
[Event(name='onShow', type='ext.chart.interactions.events.ItemInfoInteraction_item_panelEvent')]
/**
 * The ItemInfo interaction allows displaying detailed information about a series data
 * point in a popup panel.
 * <p>To attach this interaction to a chart, include an entry in the chart's
 * →<code>ext.chart.AbstractChart.interactions</code> config with the <code>iteminfo</code> type:</p>
 * <pre>
 * new Ext.chart.AbstractChart({
 *     renderTo: Ext.getBody(),
 *     width: 800,
 *     height: 600,
 *     store: store1,
 *     axes: [ ...some axes options... ],
 *     series: [ ...some series options... ],
 *     interactions: [{
 *         type: 'iteminfo',
 *         listeners: {
 *             show: function(me, item, panel) {
 *                 panel.setHtml('Stock Price: $' + item.record.get('price'));
 *             }
 *         }
 *     }]
 * });
 * </pre>
 * @see ext.chart.AbstractChart#interactions
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.ItemInfo.html Original Ext JS documentation of 'Ext.chart.interactions.ItemInfo'
 */
public class ItemInfoInteraction extends AbstractInteraction {
  /**
   * @inheritDoc
   */
  public function ItemInfoInteraction(config:ItemInfoInteraction = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Defines the gestures that should trigger the item info panel to be displayed in ExtJS.
   * @default {
   *     'start': {
   *         event: 'click',
   *         handler: 'onInfoGesture'
   *     },
   *     'move': {
   *         event: 'mousemove',
   *         handler: 'onInfoGesture'
   *     },
   *     'end': {
   *         event: 'mouseleave',
   *         handler: 'onInfoGesture'
   *     }
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.ItemInfo.html#cfg-extjsGestures Original Ext JS documentation of 'extjsGestures'
   * @see #getExtjsGestures()
   * @see #setExtjsGestures()
   */
  public native function get extjsGestures():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set extjsGestures(value:Object):void;

  /**
   * Returns the value of <code>extjsGestures</code>.
   * @see #extjsGestures
   */
  public native function getExtjsGestures():Object;

  /**
   * Sets the value of <code>extjsGestures</code>.
   * @param extjsGestures The new value.
   * @see #extjsGestures
   */
  public native function setExtjsGestures(extjsGestures:Object):void;
}
}