package ext.chart.interactions {
[Native("Ext.chart.interactions.PanZoom", require)]
/**
 * The PanZoom interaction allows the user to navigate the data for one or more chart
 * axes by panning and/or zooming. Navigation can be limited to particular axes. Zooming is
 * performed by pinching on the chart or axis area; panning is performed by single-touch dragging.
 * The interaction only works with cartesian charts/series.
 * <p>For devices which do not support multiple-touch events, zooming can not be done via pinch
 * gestures; in this case the interaction will allow the user to perform both zooming and panning
 * using the same single-touch drag gesture.
 * →<code>modeToggleButton</code> provides a button to indicate and toggle between two modes.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *     renderTo: document.body,
 *     xtype: 'cartesian',
 *     width: 600,
 *     height: 400,
 *     insetPadding: 40,
 *     interactions: [{
 *         type: 'panzoom',
 *         zoomOnPan: true
 *     }],
 *     store: {
 *         fields: ['name', 'data1', 'data2', 'data3', 'data4', 'data5'],
 *         data: [{
 *             'name': 'metric one',
 *             'data1': 10,
 *             'data2': 12,
 *             'data3': 14,
 *             'data4': 8,
 *             'data5': 13
 *         }, {
 *             'name': 'metric two',
 *             'data1': 7,
 *             'data2': 8,
 *             'data3': 16,
 *             'data4': 10,
 *             'data5': 3
 *         }, {
 *             'name': 'metric three',
 *             'data1': 5,
 *             'data2': 2,
 *             'data3': 14,
 *             'data4': 12,
 *             'data5': 7
 *         }, {
 *             'name': 'metric four',
 *             'data1': 2,
 *             'data2': 14,
 *             'data3': 6,
 *             'data4': 1,
 *             'data5': 23
 *         }, {
 *             'name': 'metric five',
 *             'data1': 27,
 *             'data2': 38,
 *             'data3': 36,
 *             'data4': 13,
 *             'data5': 33
 *         }]
 *     },
 *     axes: [{
 *         type: 'numeric',
 *         position: 'left',
 *         fields: ['data1'],
 *         title: {
 *             text: 'Sample Values',
 *             fontSize: 15
 *         },
 *         grid: true,
 *         minimum: 0
 *     }, {
 *         type: 'category',
 *         position: 'bottom',
 *         fields: ['name'],
 *         title: {
 *             text: 'Sample Values',
 *             fontSize: 15
 *         }
 *     }],
 *     series: [{
 *         type: 'line',
 *         highlight: {
 *             size: 7,
 *             radius: 7
 *         },
 *         style: {
 *             stroke: 'rgb(143,203,203)'
 *         },
 *         xField: 'name',
 *         yField: 'data1',
 *         marker: {
 *             type: 'path',
 *             path: ['M', - 2, 0, 0, 2, 2, 0, 0, - 2, 'Z'],
 *             stroke: 'blue',
 *             lineWidth: 0
 *         }
 *     }, {
 *         type: 'line',
 *         highlight: {
 *             size: 7,
 *             radius: 7
 *         },
 *         fill: true,
 *         xField: 'name',
 *         yField: 'data3',
 *         marker: {
 *             type: 'circle',
 *             radius: 4,
 *             lineWidth: 0
 *         }
 *     }]
 * });
 * </pre>
 * <p>The configuration object for the <code>panzoom</code> interaction type should specify which axes
 * will be made navigable via the <code>→axes</code> config. See the →<code>axes</code> config documentation
 * for details on the allowed formats. If the <code>→axes</code> config is not specified, it will default
 * to making all axes navigable with the default axis options.</p>
 * @see #modeToggleButton
 * @see #axes
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.PanZoom.html Original Ext JS documentation of 'Ext.chart.interactions.PanZoom'
 */
public class PanZoomInteraction extends AbstractInteraction {
  /**
   * @inheritDoc
   */
  public function PanZoomInteraction(config:PanZoomInteraction = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Specifies which axes should be made navigable. The config value can take the following
   * formats:
   * <ul>
   * <li>
   * <p>An Object with keys corresponding to the →<code>ext.chart.axis.Axis.position</code>
   * of each axis that should be made navigable. Each key's value can either be an Object
   * with further configuration options for each axis or simply <code>true</code> for a default set
   * of options.</p>
   * <pre>
   * {
   *     type: 'panzoom',
   *     axes: {
   *         left: {
   *             maxZoom: 5,
   *             allowPan: false
   *         },
   *         bottom: true
   *     }
   * }
   * </pre>
   * <p>If using the full Object form, the following options can be specified for each axis:</p>
   * <ul>
   * <li>minZoom (Number) A minimum zoom level for the axis. Defaults to <code>1</code> which is its
   * natural size.</li>
   * <li>maxZoom (Number) A maximum zoom level for the axis. Defaults to <code>10</code>.</li>
   * <li>startZoom (Number) A starting zoom level for the axis. Defaults to <code>1</code>.</li>
   * <li>allowZoom (Boolean) Whether zooming is allowed for the axis. Defaults to <code>true</code>.</li>
   * <li>allowPan (Boolean) Whether panning is allowed for the axis. Defaults to <code>true</code>.</li>
   * <li>startPan (Boolean) A starting panning offset for the axis. Defaults to <code>0</code>.</li>
   * </ul>
   * </li>
   * <li>
   * <p>An Array of strings, each one corresponding to the →<code>ext.chart.axis.Axis.position</code> of an axis that should be made navigable. The default options will be used
   * for each named axis.</p>
   * <pre>
   * {
   *     type: 'panzoom',
   *     axes: ['left', 'bottom']
   * }
   * </pre>
   * </li>
   * </ul>
   * <p>If the <code>→axes</code> config is not specified, it will default to making all axes navigable
   * with the default axis options.</p>
   * @default {
   *     top: {},
   *     right: {},
   *     bottom: {},
   *     left: {}
   * }
   * @see ext.chart.axis.Axis#position
   * @see #axes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.PanZoom.html#cfg-axes Original Ext JS documentation of 'axes'
   * @see #getAxes()
   * @see #setAxes()
   */
  public native function get axes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set axes(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * If <code>true</code>, the double tap on a chart will reset the current pan/zoom to show the whole
   * chart.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.PanZoom.html#cfg-doubleTapReset Original Ext JS documentation of 'doubleTapReset'
   * @see #getDoubleTapReset()
   * @see #setDoubleTapReset()
   */
  public native function get doubleTapReset():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set doubleTapReset(value:Boolean):void;

  [ExtConfig]
  /**
   * A set of optional overrides for the overflow arrow sprites' options. Only relevant when
   * →<code>showOverflowArrows</code> is <code>true</code>.
   * @see #showOverflowArrows
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.PanZoom.html#cfg-overflowArrowOptions Original Ext JS documentation of 'overflowArrowOptions'
   */
  public native function get overflowArrowOptions():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set overflowArrowOptions(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * If <code>true</code>, arrows will be conditionally shown at either end of each axis to indicate that
   * the axis is overflowing and can therefore be panned in that direction. Set this
   * to <code>false</code> to prevent the arrows from being displayed.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.PanZoom.html#cfg-showOverflowArrows Original Ext JS documentation of 'showOverflowArrows'
   * @see #getShowOverflowArrows()
   * @see #setShowOverflowArrows()
   */
  public native function get showOverflowArrows():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set showOverflowArrows(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * If <code>true</code>, the pan gesture will zoom the chart.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.PanZoom.html#cfg-zoomOnPan Original Ext JS documentation of 'zoomOnPan'
   * @see #getZoomOnPan()
   * @see #setZoomOnPan()
   */
  public native function get zoomOnPan():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set zoomOnPan(value:Boolean):void;

  [Deprecated(replacement="zoomOnPan", since="6.2")]
  [ExtConfig]
  [Bindable]
  /**
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.PanZoom.html#cfg-zoomOnPanGesture Original Ext JS documentation of 'zoomOnPanGesture'
   * @see #getZoomOnPanGesture()
   * @see #setZoomOnPanGesture()
   */
  public native function get zoomOnPanGesture():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set zoomOnPanGesture(value:Boolean):void;

  /**
   * Returns the value of <code>axes</code>.
   * @see #axes
   */
  public native function getAxes():*;

  /**
   * Returns the value of <code>doubleTapReset</code>.
   * @see #doubleTapReset
   */
  public native function getDoubleTapReset():Boolean;

  /**
   * Returns the value of <code>showOverflowArrows</code>.
   * @see #showOverflowArrows
   */
  public native function getShowOverflowArrows():Boolean;

  /**
   * Returns the value of <code>zoomOnPan</code>.
   * @see #zoomOnPan
   */
  public native function getZoomOnPan():Boolean;

  [Deprecated(replacement="zoomOnPan", since="6.2")]
  /**
   * Returns the value of <code>zoomOnPanGesture</code>.
   * @see #zoomOnPanGesture
   */
  public native function getZoomOnPanGesture():Boolean;

  /**
   * Sets the value of <code>axes</code>.
   * @param axes The new value.
   * @see #axes
   */
  public native function setAxes(axes:*):void;

  /**
   * Sets the value of <code>doubleTapReset</code>.
   * @param doubleTapReset The new value.
   * @see #doubleTapReset
   */
  public native function setDoubleTapReset(doubleTapReset:Boolean):void;

  /**
   * Sets the value of <code>showOverflowArrows</code>.
   * @param showOverflowArrows The new value.
   * @see #showOverflowArrows
   */
  public native function setShowOverflowArrows(showOverflowArrows:Boolean):void;

  /**
   * Sets the value of <code>zoomOnPan</code>.
   * @param zoomOnPan The new value.
   * @see #zoomOnPan
   */
  public native function setZoomOnPan(zoomOnPan:Boolean):void;

  [Deprecated(replacement="zoomOnPan", since="6.2")]
  /**
   * Sets the value of <code>zoomOnPanGesture</code>.
   * @param zoomOnPanGesture The new value.
   * @see #zoomOnPanGesture
   */
  public native function setZoomOnPanGesture(zoomOnPanGesture:Boolean):void;
}
}