package ext.chart.interactions {
[Native("Ext.chart.interactions.Rotate", require)]
/**
 * @see ext.chart.interactions.events.RotateInteraction_angleEvent.ROTATE
 * @eventType ext.chart.interactions.events.RotateInteraction_angleEvent.ROTATE
 */
[Event(name='onRotate', type='ext.chart.interactions.events.RotateInteraction_angleEvent')]
/**
 * @see ext.chart.interactions.events.RotateInteraction_angleEvent.ROTATE_END
 * @eventType ext.chart.interactions.events.RotateInteraction_angleEvent.ROTATE_END
 */
[Event(name='onRotateEnd', type='ext.chart.interactions.events.RotateInteraction_angleEvent')]
/**
 * @see ext.chart.interactions.events.RotateInteraction_angleEvent.ROTATE_START
 * @eventType ext.chart.interactions.events.RotateInteraction_angleEvent.ROTATE_START
 */
[Event(name='onRotateStart', type='ext.chart.interactions.events.RotateInteraction_angleEvent')]
/**
 * @see ext.chart.interactions.events.RotateInteraction_angleEvent.ROTATION_END
 * @eventType ext.chart.interactions.events.RotateInteraction_angleEvent.ROTATION_END
 */
[Event(name='onrotationEnd', type='ext.chart.interactions.events.RotateInteraction_angleEvent')]
/**
 * The Rotate interaction allows the user to rotate a polar chart about its central point.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.Container', {
 *     renderTo: Ext.getBody(),
 *     width: 600,
 *     height: 400,
 *     layout: 'fit',
 *     items: {
 *         xtype: 'polar',
 *         interactions: 'rotate',
 *         colors: ["#115fa6", "#94ae0a", "#a61120", "#ff8809", "#ffd13e"],
 *         store: {
 *             fields: ['name', 'data1', 'data2', 'data3', 'data4', 'data5'],
 *             data: [
 *                 {'name':'metric one', 'data1':10, 'data2':12, 'data3':14, 'data4':8, 'data5':13},
 *                 {'name':'metric two', 'data1':7, 'data2':8, 'data3':16, 'data4':10, 'data5':3},
 *                 {'name':'metric three', 'data1':5, 'data2':2, 'data3':14, 'data4':12, 'data5':7},
 *                 {'name':'metric four', 'data1':2, 'data2':14, 'data3':6, 'data4':1, 'data5':23},
 *                 {'name':'metric five', 'data1':27, 'data2':38, 'data3':36, 'data4':13, 'data5':33}
 *             ]
 *         },
 *         series: {
 *             type: 'pie',
 *             label: {
 *                 field: 'name',
 *                 display: 'rotate'
 *             },
 *             xField: 'data3',
 *             donut: 30
 *         }
 *     }
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.Rotate.html Original Ext JS documentation of 'Ext.chart.interactions.Rotate'
 */
public class RotateInteraction extends AbstractInteraction {
  /**
   * @inheritDoc
   */
  public function RotateInteraction(config:RotateInteraction = null) {
    super();
  }

  /**
   * Rotates a polar chart about its center point to the specified angle.
   * @param angle The angle to rotate to.
   * @param relative Whether the rotation is relative to the current angle
   * or not.
   * @default false
   * @param animate Whether to animate the rotation or not.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.Rotate.html#method-rotateTo Original Ext JS documentation of 'rotateTo'
   */
  public native function rotateTo(angle:Number, relative:Boolean = false, animate:Boolean = false):void;
}
}