package ext.chart.interactions.events {
import ext.chart.AbstractChart;
import ext.chart.interactions.ItemEditInteraction;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.chart.interactions.events.ItemEditInteraction_chart_interaction_itemEvent")]
public class ItemEditInteraction_chart_interaction_itemEvent extends FlExtEvent {
  /**
   * Fires when item edit operation (dragging) begins.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.ItemEdit.html#event-beginitemedit Original Ext JS documentation of 'beginitemedit'
   * @see ext.chart.interactions.ItemEditInteraction
   * @eventType onBeginItemEdit
   */
  public static const BEGIN_ITEM_EDIT:String = "onBeginItemEdit";
  public static const __PARAMETER_SEQUENCE__:Array = ["chart", "interaction", "item", "eOpts"];

  public function ItemEditInteraction_chart_interaction_itemEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The chart the interaction belongs to.
   */
  public native function get chart():AbstractChart;

  /**
   * The interaction.
   */
  public native function get interaction():ItemEditInteraction;

  /**
   * The item that is about to be edited.
   */
  public native function get item():Object;
}
}