package ext.chart.interactions.events {
import ext.chart.AbstractChart;
import ext.chart.interactions.ItemEditInteraction;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.chart.interactions.events.ItemEditInteraction_chart_interaction_item_targetEvent")]
public class ItemEditInteraction_chart_interaction_item_targetEvent extends FlExtEvent {
  /**
   * Fires when item edit operation (dragging) ends.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.ItemEdit.html#event-enditemedit Original Ext JS documentation of 'enditemedit'
   * @see ext.chart.interactions.ItemEditInteraction
   * @eventType onEndItemEdit
   */
  public static const END_ITEM_EDIT:String = "onEndItemEdit";
  public static const __PARAMETER_SEQUENCE__:Array = ["chart", "interaction", "item", "target", "eOpts"];

  public function ItemEditInteraction_chart_interaction_item_targetEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The chart the interaction belongs to.
   */
  public native function get chart():AbstractChart;

  /**
   * The interaction.
   */
  public native function get interaction():ItemEditInteraction;

  /**
   * The item that was edited.
   */
  public native function get item():Object;

  /**
   * The object containing target values the were used.
   */
  public native function get target():Object;
}
}