package ext.chart.interactions.events {
import ext.chart.interactions.RotateInteraction;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.chart.interactions.events.RotateInteraction_angleEvent")]
public class RotateInteraction_angleEvent extends FlExtEvent {
  /**
   * Fires on every tick of the rotation.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.Rotate.html#event-rotate Original Ext JS documentation of 'rotate'
   * @see ext.chart.interactions.RotateInteraction
   * @eventType onRotate
   */
  public static const ROTATE:String = "onRotate";
  /**
   * Fires after a user finishes the rotation.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.Rotate.html#event-rotateend Original Ext JS documentation of 'rotateend'
   * @see ext.chart.interactions.RotateInteraction
   * @eventType onRotateEnd
   */
  public static const ROTATE_END:String = "onRotateEnd";
  /**
   * Fires when a user initiates the rotation.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.Rotate.html#event-rotatestart Original Ext JS documentation of 'rotatestart'
   * @see ext.chart.interactions.RotateInteraction
   * @eventType onRotateStart
   */
  public static const ROTATE_START:String = "onRotateStart";
  /**
   * Fires after a user finishes the rotation
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.interactions.Rotate.html#event-rotationEnd Original Ext JS documentation of 'rotationEnd'
   * @see ext.chart.interactions.RotateInteraction
   * @eventType onrotationEnd
   */
  public static const ROTATION_END:String = "onrotationEnd";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "angle", "eOpts"];

  public function RotateInteraction_angleEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The new current rotation angle.
   */
  public native function get angle():Number;

  /**
   * This interaction.
   */
  public native function get source():RotateInteraction;
}
}