package ext.chart.legend {
[Native("Ext.chart.legend.Legend", require)]
/**
 * This class provides a dataview-based chart legend.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.legend.Legend.html Original Ext JS documentation of 'Ext.chart.legend.Legend'
 */
public class Legend extends LegendBase {
  /**
   * @inheritDoc
   */
  public function Legend(config:Legend = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * The rect of the legend relative to its container.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.legend.Legend.html#cfg-rect Original Ext JS documentation of 'rect'
   * @see #getRect()
   * @see #setRect()
   */
  public native function get rect():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set rect(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to allow series items to have their visibility
   * toggled by interaction with the legend items.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.legend.Legend.html#cfg-toggleable Original Ext JS documentation of 'toggleable'
   * @see #getToggleable()
   * @see #setToggleable()
   */
  public native function get toggleable():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set toggleable(value:Boolean):void;

  /**
   * Returns the value of <code>rect</code>.
   * @see #rect
   */
  public native function getRect():Array;

  /**
   * Returns the value of <code>toggleable</code>.
   * @see #toggleable
   */
  public native function getToggleable():Boolean;

  /**
   * Sets the value of <code>rect</code>.
   * @param rect The new value.
   * @see #rect
   */
  public native function setRect(rect:Array):void;

  /**
   * Sets the value of <code>toggleable</code>.
   * @param toggleable The new value.
   * @see #toggleable
   */
  public native function setToggleable(toggleable:Boolean):void;
}
}