package ext.chart.legend {
import ext.Component;
import ext.view.DataView;

[Native("Ext.chart.legend.LegendBase", require)]
/**
 * The legend base class adapater for classic toolkit.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.legend.LegendBase.html Original Ext JS documentation of 'Ext.chart.legend.LegendBase'
 */
public class LegendBase extends DataView {
  /**
   * @inheritDoc
   */
  public function LegendBase(config:LegendBase = null) {
    super(config);
  }

  [ExtConfig]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.legend.LegendBase.html#cfg-dock Original Ext JS documentation of 'dock'
   * @see #setDock()
   */
  override public native function get dock():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set dock(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The dock position of this component in its container. Can be <code>left</code>, <code>top</code>, <code>right</code>,
   * or <code>bottom</code>.
   * @default 'bottom'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.legend.LegendBase.html#cfg-docked Original Ext JS documentation of 'docked'
   * @see #getDocked()
   * @see #setDocked()
   */
  public native function get docked():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set docked(value:String):void;

  /**
   * Returns the value of <code>docked</code>.
   * @see #docked
   */
  public native function getDocked():String;

  /**
   * Sets the value of <code>docked</code>.
   * @param dock The dock position.
   * @see #docked
   */
  override public native function setDocked(dock:Object):Component;
}
}