package ext.chart.legend {
import ext.chart.AbstractChart;
import ext.draw.Surface;
import ext.mixin.Observable;

[Native("Ext.chart.legend.SpriteLegend", require)]
[ExtConfig]
/**
 * This class uses <code>→ext.draw.sprite.Sprite</code> to render the chart legend.
 * <p>The DOM legend is essentially a data view docked inside a draw container, which a chart is.
 * The sprite legend, on the other hand, is not a foreign entity in a draw container,
 * and is rendered in a draw surface with sprites, just like series and axes.</p>
 * <p>This means that:</p>
 * <ul>
 * <li>it is styleable with chart themes</li>
 * <li>it shows up in chart preview and chart download</li>
 * <li>it renders markers exactly as they are in the series</li>
 * <li>it can't be styled with CSS</li>
 * <li>it doesn't scroll, instead the items are grouped into columns,
 * and the legend grows in size as the number of items increases</li>
 * </ul>
 * @see ext.draw.sprite.Sprite
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.legend.SpriteLegend.html Original Ext JS documentation of 'Ext.chart.legend.SpriteLegend'
 */
public class SpriteLegend extends Observable {
  /**
   * @inheritDoc
   */
  public function SpriteLegend(config:SpriteLegend = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * Sets the legend background.
   * This can be a gradient object, image, or color. This config works similarly
   * to the →<code>ext.chart.AbstractChart.background</code> config.
   * @see ext.chart.AbstractChart#background
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.legend.SpriteLegend.html#cfg-background Original Ext JS documentation of 'background'
   * @see #getBackground()
   * @see #setBackground()
   */
  public native function get background():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set background(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The border that goes around legend item sprites.
   * The type of the sprite is determined by this config,
   * while the styling comes from a theme <i>legend</i> (→<code>ext.chart.theme.ChartTheme</code>).
   * If both this config and the theme provide values for the
   * same configs, the values from this config are used.
   * The sprite class used a legend border should have the <code>isLegendBorder</code>
   * property set to true on the prototype. The legend border sprite
   * should also have the <code>x</code>, <code>y</code>, <code>width</code> and <code>height</code> attributes
   * that determine it's position and dimensions.
   * @default {
   *     type: 'legendborder'
   * }
   * @see ext.chart.theme.ChartTheme
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.legend.SpriteLegend.html#cfg-border Original Ext JS documentation of 'border'
   * @see #getBorder()
   * @see #setBorder()
   */
  public native function get border():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set border(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The chart that the store belongs to.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.legend.SpriteLegend.html#cfg-chart Original Ext JS documentation of 'chart'
   * @see #getChart()
   * @see #setChart()
   */
  public native function get chart():AbstractChart;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set chart(value:AbstractChart):void;

  [ExtConfig]
  [Bindable]
  /**
   * The position of the legend in the chart.
   * @default 'bottom'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.legend.SpriteLegend.html#cfg-docked Original Ext JS documentation of 'docked'
   * @see #getDocked()
   * @see #setDocked()
   */
  public native function get docked():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set docked(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Toggles the visibility of the legend.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.legend.SpriteLegend.html#cfg-hidden Original Ext JS documentation of 'hidden'
   * @see #getHidden()
   * @see #setHidden()
   */
  public native function get hidden():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set hidden(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The sprite to use as a legend item marker. By default a corresponding series
   * marker is used. If the series has no marker, the <code>circle</code> sprite
   * is used as a legend item marker, where its <code>fillStyle</code>, <code>strokeStyle</code> and
   * <code>lineWidth</code> match that of the series. The size of a legend item marker is
   * controlled by the <code>→size</code> property, which to defaults to <code>10</code> (pixels).
   * @default {}
   * @see #size
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.legend.SpriteLegend.html#cfg-marker Original Ext JS documentation of 'marker'
   * @see #getMarker()
   * @see #setMarker()
   */
  public native function get marker():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set marker(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The padding amount between legend items and legend border.
   * @default 10
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.legend.SpriteLegend.html#cfg-padding Original Ext JS documentation of 'padding'
   * @see #getPadding()
   * @see #setPadding()
   */
  public native function get padding():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set padding(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The size of the area occupied by the legend's sprites.
   * This is set by the legend itself and then used during chart layout
   * to make sure the 'legend' surface is big enough to accommodate
   * legend sprites.
   * @default {
   *     width: 0,
   *     height: 0
   * }
   * <ul>
   * <li><code>width:Number</code> (optional)</li>
   * <li><code>height:Number</code> (optional)</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.legend.SpriteLegend.html#cfg-size Original Ext JS documentation of 'size'
   * @see #getSize()
   */
  public native function get size():Object;

  [ExtConfig]
  [Bindable]
  /**
   * The chart surface used to render legend sprites.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.legend.SpriteLegend.html#cfg-surface Original Ext JS documentation of 'surface'
   * @see #getSurface()
   * @see #setSurface()
   */
  public native function get surface():Surface;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set surface(value:Surface):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to allow series items to have their visibility
   * toggled by interaction with the legend items.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.legend.SpriteLegend.html#cfg-toggleable Original Ext JS documentation of 'toggleable'
   * @see #getToggleable()
   * @see #setToggleable()
   */
  public native function get toggleable():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set toggleable(value:Boolean):void;

  /**
   * Returns the value of <code>background</code>.
   * @see #background
   */
  public native function getBackground():Object;

  /**
   * Returns the value of <code>border</code>.
   * @see #border
   */
  public native function getBorder():Object;

  /**
   * Returns the value of <code>chart</code>.
   * @see #chart
   */
  public native function getChart():AbstractChart;

  /**
   * Returns the value of <code>docked</code>.
   * @see #docked
   */
  public native function getDocked():String;

  /**
   * Returns the value of <code>hidden</code>.
   * @see #hidden
   */
  public native function getHidden():Boolean;

  /**
   * Returns the value of <code>marker</code>.
   * @see #marker
   */
  public native function getMarker():*;

  /**
   * Returns the value of <code>padding</code>.
   * @see #padding
   */
  public native function getPadding():Number;

  /**
   * Returns the value of <code>size</code>.
   * @see #size
   */
  public native function getSize():Object;

  /**
   * Returns the value of <code>surface</code>.
   * @see #surface
   */
  public native function getSurface():Surface;

  /**
   * Returns the value of <code>toggleable</code>.
   * @see #toggleable
   */
  public native function getToggleable():Boolean;

  /**
   * Sets the value of <code>background</code>.
   * @param background The new value.
   * @see #background
   */
  public native function setBackground(background:Object):void;

  /**
   * Sets the value of <code>border</code>.
   * @param border The new value.
   * @see #border
   */
  public native function setBorder(border:Object):void;

  /**
   * Sets the value of <code>chart</code>.
   * @param chart The new value.
   * @see #chart
   */
  public native function setChart(chart:AbstractChart):void;

  /**
   * Sets the value of <code>docked</code>.
   * @param docked The new value.
   * @see #docked
   */
  public native function setDocked(docked:String):void;

  /**
   * Sets the value of <code>hidden</code>.
   * @param hidden The new value.
   * @see #hidden
   */
  public native function setHidden(hidden:Boolean):void;

  /**
   * Sets the value of <code>marker</code>.
   * @param marker The new value.
   * @see #marker
   */
  public native function setMarker(marker:*):void;

  /**
   * Sets the value of <code>padding</code>.
   * @param padding The new value.
   * @see #padding
   */
  public native function setPadding(padding:Number):void;

  /**
   * Sets the value of <code>surface</code>.
   * @param surface The new value.
   * @see #surface
   */
  public native function setSurface(surface:Surface):void;

  /**
   * Sets the value of <code>toggleable</code>.
   * @param toggleable The new value.
   * @see #toggleable
   */
  public native function setToggleable(toggleable:Boolean):void;
}
}