package ext.chart.navigator {
import ext.Component;
import ext.chart.axis.Axis;

[Native("Ext.chart.navigator.Navigator", require)]
/**
 * The Navigator component is used to visually set the visible range of the x-axis
 * of a cartesian chart.
 * <p>This component is meant to be used with the Navigator Container
 * via its →<code>ext.chart.navigator.ChartNavigatorContainer.navigator</code> config.</p>
 * <p>IMPORTANT: even though the Navigator component is a kind of chart, it should not be
 * treated as such. Correct behavior is not guaranteed when using hidden/private configs.</p>
 * @see ext.chart.navigator.ChartNavigatorContainer#navigator
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html Original Ext JS documentation of 'Ext.chart.navigator.Navigator'
 */
public class ChartNavigator extends ChartNavigatorBase {
  /**
   * @inheritDoc
   */
  public function ChartNavigator(config:ChartNavigator = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-axes Original Ext JS documentation of 'axes'
   * @see #getAxes()
   * @see #setAxes()
   */
  override public native function get axes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set axes(value:*):void;

  [ExtConfig]
  /**
   * <b>This is a required setting</b>. The ID of the <i>chart's</i> (→<code>chart</code>) axis to link to.
   * The axis should be positioned to 'bottom' or 'top' in the chart.
   * @see #chart
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-axis Original Ext JS documentation of 'axis'
   * @see #setAxis()
   */
  public native function get axis():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set axis(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * @default 'bottom'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-docked Original Ext JS documentation of 'docked'
   * @see #getDocked()
   * @see #setDocked()
   */
  public native function get docked():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set docked(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-flipXY Original Ext JS documentation of 'flipXY'
   * @see #getFlipXY()
   * @see #setFlipXY()
   */
  override public native function get flipXY():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set flipXY(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The height of the navigator component.
   * @default 75
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-height Original Ext JS documentation of 'height'
   * @see #getHeight()
   * @see #setHeight()
   */
  override public native function get height():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set height(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-highlightItem Original Ext JS documentation of 'highlightItem'
   * @see #getHighlightItem()
   * @see #setHighlightItem()
   */
  override public native function get highlightItem():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set highlightItem(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-innerPadding Original Ext JS documentation of 'innerPadding'
   * @see #getInnerPadding()
   * @see #setInnerPadding()
   */
  override public native function get innerPadding():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set innerPadding(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-insetPadding Original Ext JS documentation of 'insetPadding'
   * @see #getInsetPadding()
   * @see #setInsetPadding()
   */
  override public native function get insetPadding():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set insetPadding(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-interactions Original Ext JS documentation of 'interactions'
   * @see #getInteractions()
   * @see #setInteractions()
   */
  override public native function get interactions():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set interactions(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-legend Original Ext JS documentation of 'legend'
   * @see #getLegend()
   * @see #setLegend()
   */
  override public native function get legend():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set legend(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The end of the visible range, where the visible range is a [0, 1] interval.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-maximum Original Ext JS documentation of 'maximum'
   * @see #getMaximum()
   * @see #setMaximum()
   */
  public native function get maximum():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set maximum(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The start of the visible range, where the visible range is a [0, 1] interval.
   * @default 0.8
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-minimum Original Ext JS documentation of 'minimum'
   * @see #getMinimum()
   * @see #setMinimum()
   */
  public native function get minimum():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set minimum(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-series Original Ext JS documentation of 'series'
   * @see #getSeries()
   * @see #setSeries()
   */
  override public native function get series():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set series(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Whether the navigator should span the 'series' (default) or the whole 'chart'.
   * @default 'series'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-span Original Ext JS documentation of 'span'
   * @see #getSpan()
   * @see #setSpan()
   */
  public native function get span():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set span(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-store Original Ext JS documentation of 'store'
   * @see #getStore()
   * @see #setStore()
   */
  override public native function get store():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set store(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-theme Original Ext JS documentation of 'theme'
   * @see #getTheme()
   * @see #setTheme()
   */
  override public native function get theme():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set theme(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Minimum gap between navigator thumbs in pixels.
   * @default 30
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-thumbGap Original Ext JS documentation of 'thumbGap'
   * @see #getThumbGap()
   * @see #setThumbGap()
   */
  public native function get thumbGap():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set thumbGap(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The maximum horizontal delta between the pointer/finger and the center of a navigator
   * thumb. Used for hit testing.
   * @default 20
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Navigator.html#cfg-tolerance Original Ext JS documentation of 'tolerance'
   * @see #getTolerance()
   * @see #setTolerance()
   */
  public native function get tolerance():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set tolerance(value:Number):void;

  /**
   * Returns the value of <code>axes</code>.
   * @see #axes
   */
  override public native function getAxes():*;

  /**
   * Returns the value of <code>axis</code>.
   * @param axis You may request an axis by passing
   * an id, the number of the array key returned by →<code>getAxes</code>, or an axis instance.
   * @see #axis
   * @see #getAxes
   */
  override public native function getAxis(axis:*):Axis;

  /**
   * Returns the value of <code>docked</code>.
   * @see #docked
   */
  public native function getDocked():String;

  /**
   * Returns the value of <code>flipXY</code>.
   * @see #flipXY
   */
  override public native function getFlipXY():Boolean;

  /**
   * Returns the value of <code>height</code>.
   * @see #height
   */
  override public native function getHeight():*;

  /**
   * Returns the value of <code>highlightItem</code>.
   * @see #highlightItem
   */
  override public native function getHighlightItem():Object;

  /**
   * Returns the value of <code>innerPadding</code>.
   * @see #innerPadding
   */
  override public native function getInnerPadding():Object;

  /**
   * Returns the value of <code>insetPadding</code>.
   * @see #insetPadding
   */
  override public native function getInsetPadding():*;

  /**
   * Returns the value of <code>interactions</code>.
   * @see #interactions
   */
  override public native function getInteractions():Array;

  /**
   * Returns the value of <code>legend</code>.
   * @see #legend
   */
  override public native function getLegend():*;

  /**
   * Returns the value of <code>maximum</code>.
   * @see #maximum
   */
  public native function getMaximum():Number;

  /**
   * Returns the value of <code>minimum</code>.
   * @see #minimum
   */
  public native function getMinimum():Number;

  /**
   * Returns the value of <code>series</code>.
   * @see #series
   */
  override public native function getSeries():*;

  /**
   * Returns the value of <code>span</code>.
   * @see #span
   */
  public native function getSpan():String;

  /**
   * Returns the value of <code>store</code>.
   * @see #store
   */
  override public native function getStore():*;

  /**
   * Returns the value of <code>theme</code>.
   * @see #theme
   */
  override public native function getTheme():String;

  /**
   * Returns the value of <code>thumbGap</code>.
   * @see #thumbGap
   */
  public native function getThumbGap():Number;

  /**
   * Returns the value of <code>tolerance</code>.
   * @see #tolerance
   */
  public native function getTolerance():Number;

  /**
   * Sets the value of <code>axes</code>.
   * @param axes The new value.
   * @see #axes
   */
  override public native function setAxes(axes:*):void;

  /**
   * Sets the value of <code>axis</code>.
   * @param axis The new value.
   * @see #axis
   */
  public native function setAxis(axis:String):void;

  /**
   * Sets the value of <code>docked</code>.
   * @param dock The dock position.
   * @see #docked
   */
  override public native function setDocked(dock:Object):Component;

  /**
   * Sets the value of <code>flipXY</code>.
   * @param flipXY The new value.
   * @see #flipXY
   */
  override public native function setFlipXY(flipXY:Boolean):void;

  /**
   * Sets the value of <code>height</code>.
   * @param height The new height to set. This may be one of:
   * <ul>
   * <li>A Number specifying the new height in pixels.</li>
   * <li>A String used to set the CSS height style.</li>
   * <li><code>undefined</code> to leave the height unchanged.</li>
   * <li><code>null</code> to clear the height.</li>
   * </ul>
   * @see #height
   */
  override public native function setHeight(height:*):Component;

  /**
   * Sets the value of <code>highlightItem</code>.
   * @param highlightItem The new value.
   * @see #highlightItem
   */
  override public native function setHighlightItem(highlightItem:Object):void;

  /**
   * Sets the value of <code>innerPadding</code>.
   * @param innerPadding The new value.
   * @see #innerPadding
   */
  override public native function setInnerPadding(innerPadding:Object):void;

  /**
   * Sets the value of <code>insetPadding</code>.
   * @param insetPadding The new value.
   * @see #insetPadding
   */
  override public native function setInsetPadding(insetPadding:*):void;

  /**
   * Sets the value of <code>interactions</code>.
   * @param interactions The new value.
   * @see #interactions
   */
  override public native function setInteractions(interactions:Array):void;

  /**
   * Sets the value of <code>legend</code>.
   * @param legend The new value.
   * @see #legend
   */
  override public native function setLegend(legend:*):void;

  /**
   * Sets the value of <code>maximum</code>.
   * @param maximum The new value.
   * @see #maximum
   */
  public native function setMaximum(maximum:Number):void;

  /**
   * Sets the value of <code>minimum</code>.
   * @param minimum The new value.
   * @see #minimum
   */
  public native function setMinimum(minimum:Number):void;

  /**
   * Sets the value of <code>series</code>.
   * @param series The new value.
   * @see #series
   */
  override public native function setSeries(series:*):void;

  /**
   * Sets the value of <code>span</code>.
   * @param span The new value.
   * @see #span
   */
  public native function setSpan(span:String):void;

  /**
   * Sets the value of <code>store</code>.
   * @param store The new value.
   * @see #store
   */
  override public native function setStore(store:*):void;

  /**
   * Sets the value of <code>theme</code>.
   * @param theme The new value.
   * @see #theme
   */
  override public native function setTheme(theme:String):void;

  /**
   * Sets the value of <code>thumbGap</code>.
   * @param thumbGap The new value.
   * @see #thumbGap
   */
  public native function setThumbGap(thumbGap:Number):void;

  /**
   * Sets the value of <code>tolerance</code>.
   * @param tolerance The new value.
   * @see #tolerance
   */
  public native function setTolerance(tolerance:Number):void;
}
}