package ext.chart.navigator {
import ext.chart.CartesianChart;

[Native("Ext.chart.navigator.Container", require)]
/**
 * The Navigator Container is a component used to lay out the chart and its
 * <i>navigator</i> (→<code>ext.chart.navigator.ChartNavigator</code>), where the navigator is docked
 * to the top/bottom, and the chart fills the rest of the container's space.
 * <p>For example:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *     xtype: 'chartnavigator',
 *     renderTo: Ext.getBody(),
 *     width: 600,
 *     height: 400,
 *
 *     chart: {
 *         xtype: 'cartesian',
 *
 *         store: {
 *             data: (function () {
 *                 var data = [];
 *                 for (var i = 0; i &lt; 360; i++) {
 *                     data.push({
 *                         x: i,
 *                         y: Math.sin(i / 45 &#42; Math.PI)
 *                     });
 *                 }
 *                 return data;
 *             })()
 *         },
 *         axes: [
 *             {
 *                 id: 'navigable-axis',
 *
 *                 type: 'numeric',
 *                 position: 'bottom'
 *             },
 *             {
 *                 type: 'numeric',
 *                 position: 'left'
 *             }
 *         ],
 *         series: {
 *             type: 'line',
 *             xField: 'x',
 *             yField: 'y'
 *         }
 *     },
 *
 *     navigator: {
 *         axis: 'navigable-axis'
 *     }
 * });
 * </pre>
 * @see ext.chart.navigator.ChartNavigator
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Container.html Original Ext JS documentation of 'Ext.chart.navigator.Container'
 */
public class ChartNavigatorContainer extends ChartNavigatorContainerBase {
  /**
   * @inheritDoc
   */
  public function ChartNavigatorContainer(config:ChartNavigatorContainer = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * The chart to make navigable.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Container.html#cfg-chart Original Ext JS documentation of 'chart'
   * @see #getChart()
   * @see #setChart()
   */
  public native function get chart():CartesianChart;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set chart(value:CartesianChart):void;

  [ExtConfig]
  [Bindable]
  /**
   * @default {}
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.navigator.Container.html#cfg-navigator Original Ext JS documentation of 'navigator'
   * @see #getNavigator()
   * @see #setNavigator()
   */
  public native function get navigator():ChartNavigator;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set navigator(value:ChartNavigator):void;

  /**
   * Returns the value of <code>chart</code>.
   * @see #chart
   */
  public native function getChart():CartesianChart;

  /**
   * Returns the value of <code>navigator</code>.
   * @see #navigator
   */
  public native function getNavigator():ChartNavigator;

  /**
   * Sets the value of <code>chart</code>.
   * @param chart The new value.
   * @see #chart
   */
  public native function setChart(chart:CartesianChart):void;

  /**
   * Sets the value of <code>navigator</code>.
   * @param navigator The new value.
   * @see #navigator
   */
  public native function setNavigator(navigator:ChartNavigator):void;
}
}