package ext.chart.plugin {
import ext.plugin.AbstractPlugin;

[Native("Ext.chart.plugin.ItemEvents", require)]
/**
 * A chart <i>plugin</i> (→<code>ext.plugin.AbstractPlugin</code>) that adds ability to listen to chart series
 * items events. Item event listeners are passed two parameters: the target item and the
 * event itself. The item object has the following properties:
 * <ul>
 * <li><b>category</b> - the category the item falls under: 'items' or 'markers'</li>
 * <li><b>field</b> - the store field used by this series item</li>
 * <li><b>index</b> - the index of the series item</li>
 * <li><b>record</b> - the store record associated with this series item</li>
 * <li><b>series</b> - the series the item belongs to</li>
 * <li><b>sprite</b> - the sprite used to represents this series item</li>
 * </ul>
 * <p>For example:</p>
 * <pre>
 * Ext.create('Ext.chart.CartesianChart', {
 *     plugins: {
 *         chartitemevents: {
 *             moveEvents: true
 *         }
 *     },
 *     store: {
 *         fields: ['pet', 'households', 'total'],
 *         data: [
 *             {pet: 'Cats', households: 38, total: 93},
 *             {pet: 'Dogs', households: 45, total: 79},
 *             {pet: 'Fish', households: 13, total: 171}
 *         ]
 *     },
 *     axes: [{
 *         type: 'numeric',
 *         position: 'left'
 *     }, {
 *         type: 'category',
 *         position: 'bottom'
 *     }],
 *     series: [{
 *         type: 'bar',
 *         xField: 'pet',
 *         yField: 'households',
 *         listeners: {
 *             itemmousemove: function (series, item, event) {
 *                  console.log('itemmousemove', item.category, item.field);
 *             }
 *         }
 *     }, {
 *         type: 'line',
 *         xField: 'pet',
 *         yField: 'total',
 *         marker: true
 *     }],
 *     listeners: { // Listen to itemclick events on all series.
 *         itemclick: function (chart, item, event) {
 *             console.log('itemclick', item.category, item.field);
 *         }
 *     }
 * });
 * </pre>
 * @see ext.plugin.AbstractPlugin
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.plugin.ItemEvents.html Original Ext JS documentation of 'Ext.chart.plugin.ItemEvents'
 */
public class ChartItemEventsPlugin extends AbstractPlugin {
  /**
   * @inheritDoc
   */
  public function ChartItemEventsPlugin(config:ChartItemEventsPlugin = null) {
    super(config);
  }

  [ExtConfig]
  /**
   * If <code>itemmousemove</code>, <code>itemmouseover</code> or <code>itemmouseout</code> event listeners are attached
   * to the chart, the plugin will detect those and will hit test series items on
   * every move. However, if the above item events are attached on the series level
   * only, this config has to be set to true, as the plugin won't perform a similar
   * detection on every series.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.plugin.ItemEvents.html#cfg-moveEvents Original Ext JS documentation of 'moveEvents'
   */
  public native function get moveEvents():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set moveEvents(value:Boolean):void;
}
}