package ext.chart.series {

[Native("Ext.chart.series.Area", require)]
/**
 * Creates an Area Chart.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'cartesian',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    insetPadding: 40,
 *    store: {
 *        fields: ['name', 'data1', 'data2', 'data3'],
 *        data: [{
 *            name: 'metric one',
 *            data1: 10,
 *            data2: 12,
 *            data3: 14
 *        }, {
 *            name: 'metric two',
 *            data1: 7,
 *            data2: 8,
 *            data3: 16
 *        }, {
 *            name: 'metric three',
 *            data1: 5,
 *            data2: 2,
 *            data3: 14
 *        }, {
 *            name: 'metric four',
 *            data1: 2,
 *            data2: 14,
 *            data3: 6
 *        }, {
 *            name: 'metric five',
 *            data1: 27,
 *            data2: 38,
 *            data3: 36
 *        }]
 *    },
 *    axes: [{
 *        type: 'numeric',
 *        position: 'left',
 *        fields: ['data1'],
 *        grid: true,
 *        minimum: 0
 *    }, {
 *        type: 'category',
 *        position: 'bottom',
 *        fields: ['name']
 *    }],
 *    series: {
 *        type: 'area',
 *        subStyle: {
 *            fill: ['#0A3F50', '#30BDA7', '#96D4C6']
 *        },
 *        xField: 'name',
 *        yField: ['data1', 'data2', 'data3']
 *    }
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Area.html Original Ext JS documentation of 'Ext.chart.series.Area'
 */
public class AreaSeries extends StackedCartesianSeries {
  /**
   * @inheritDoc
   */
  public function AreaSeries(config:AreaSeries = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * A function that can be provided to set custom styling properties to each
   * rendered element. It receives <code>(sprite, config, rendererData, index)</code>
   * as parameters.
   * Area series renderers only affect markers.
   * For styling individual segments with a renderer it is possible to use
   * the Line series with →<code>ext.chart.series.LineSeries.fill</code> config set to <code>true</code>,
   * which makes Line series look like Area series.
   * <ul>
   * <li><code>sprite:Object</code> —
   * The sprite affected by the renderer.
   * The visual attributes are in <code>sprite.attr</code>.
   * The data field is available in <code>sprite.getField()</code>.
   * </li>
   * <li><code>config:Object</code> —
   * The sprite configuration, which varies with the series
   * and the type of sprite. For instance, a Line chart sprite might have just the
   * <code>x</code> and <code>y</code> properties while a Bar chart sprite also has <code>width</code> and <code>height</code>.
   * A <code>→type</code> might be present too. For instance to draw each marker and each segment
   * of a Line chart, the renderer is called with the <code>config.type</code> set to either
   * <code>→marker</code> or <code>line</code>.
   * </li>
   * <li><code>rendererData:Object</code> —
   * A record with different properties depending on
   * the type of chart. The only guaranteed property is <code>rendererData.store</code>, the
   * store used by the series. In some cases, a store may not exist: for instance
   * a Gauge chart may read its value directly from its configuration; in this case
   * rendererData.store is null and the value is available in rendererData.value.
   * </li>
   * <li><code>index:Number</code> —
   * The index of the sprite. It is usually the index of the
   * store record associated with the sprite, in which case the record can be obtained
   * with <code>store.getData().items[index]</code>. If the chart is not associated with a store,
   * the index represents the index of the sprite within the series. For instance
   * a Gauge chart may have as many sprites as there are sectors in the background of
   * the gauge, plus one for the needle.
   * </li>
   * <li><code>null:Object</code> —
   * The attributes that have been changed or added.
   * Note: it is usually possible to add or modify the attributes directly into the
   * <code>config</code> parameter and not return anything, but returning an object with only
   * those attributes that have been changed may allow for optimizations in the
   * rendering of some series. Example to draw every other marker in red:
   * <pre>
   *  renderer: function (sprite, config, rendererData, index) {
   *      if (config.type === 'marker') {
   *          return { strokeStyle: (index % 2 === 0 ? 'red' : 'black') };
   *      }
   *  }
   * </pre>
   * </li>
   * </ul>
   * @see ext.chart.series.LineSeries#fill
   * @see #type
   * @see #marker
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Area.html#cfg-renderer Original Ext JS documentation of 'renderer'
   * @see #getRenderer()
   * @see #setRenderer()
   */
  override public native function get renderer():Function;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set renderer(value:Function):void;

  /**
   * Default series sprite type.
   * @default 'areaSeries'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Area.html#property-seriesType Original Ext JS documentation of 'seriesType'
   */
  override public native function get seriesType():String;

  /**
   * @private
   */
  override public native function set seriesType(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to stack negative/positive values in respective y-axis directions.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Area.html#cfg-splitStacks Original Ext JS documentation of 'splitStacks'
   * @see #getSplitStacks()
   * @see #setSplitStacks()
   */
  override public native function get splitStacks():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set splitStacks(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Custom style configuration for the sprite used in the series.
   * It overrides the style that is provided by the current theme. See
   * →<code>ext.chart.theme.series.AreaSeriesTheme</code>
   * @see ext.chart.theme.series.AreaSeriesTheme
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Area.html#cfg-style Original Ext JS documentation of 'style'
   * @see #getStyle()
   * @see #setStyle()
   */
  override public native function get style():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set style(value:Object):void;

  /**
   * Returns the value of <code>renderer</code>.
   * @see #renderer
   */
  override public native function getRenderer():Function;

  /**
   * Returns the value of <code>splitStacks</code>.
   * @see #splitStacks
   */
  override public native function getSplitStacks():Boolean;

  /**
   * Returns the value of <code>style</code>.
   * @see #style
   */
  override public native function getStyle():Object;

  /**
   * Sets the value of <code>renderer</code>.
   * @param renderer The new value.
   * @see #renderer
   */
  override public native function setRenderer(renderer:Function):void;

  /**
   * Sets the value of <code>splitStacks</code>.
   * @param splitStacks The new value.
   * @see #splitStacks
   */
  override public native function setSplitStacks(splitStacks:Boolean):void;

  /**
   * Sets the value of <code>style</code>.
   * @param style The new value.
   * @see #style
   */
  override public native function setStyle(style:Object):void;
}
}