package ext.chart.series {

[Native("Ext.chart.series.Bar3D", require)]
/**
 * Creates a 3D Bar or 3D Column Chart (depending on the value of the
 * →<code>ext.chart.CartesianChart.flipXY</code> config).
 * <p>Note: 'bar3d' series is meant to be used with the
 * <i>'category3d'</i> (→<code>ext.chart.axis.AxisCategory</code>) axis as its x-axis.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'cartesian',
 *    renderTo: Ext.getBody(),
 *    width: 600,
 *    height: 400,
 *    innerPadding: '0 10 0 10',
 *    store: {
 *        fields: ['name', 'apples', 'oranges'],
 *        data: [{
 *            name: 'Eric',
 *            apples: 10,
 *            oranges: 3
 *        }, {
 *            name: 'Mary',
 *            apples: 7,
 *            oranges: 2
 *        }, {
 *            name: 'John',
 *            apples: 5,
 *            oranges: 2
 *        }, {
 *            name: 'Bob',
 *            apples: 2,
 *            oranges: 3
 *        }, {
 *            name: 'Joe',
 *            apples: 19,
 *            oranges: 1
 *        }, {
 *            name: 'Macy',
 *            apples: 13,
 *            oranges: 4
 *        }]
 *    },
 *    axes: [{
 *        type: 'numeric3d',
 *        position: 'left',
 *        fields: ['apples', 'oranges'],
 *        title: {
 *            text: 'Inventory',
 *            fontSize: 15
 *        },
 *        grid: {
 *            odd: {
 *                fillStyle: 'rgba(255, 255, 255, 0.06)'
 *            },
 *            even: {
 *                fillStyle: 'rgba(0, 0, 0, 0.03)'
 *            }
 *        }
 *    }, {
 *        type: 'category3d',
 *        position: 'bottom',
 *        title: {
 *            text: 'People',
 *            fontSize: 15
 *        },
 *        fields: 'name'
 *    }],
 *    series: {
 *        type: 'bar3d',
 *        xField: 'name',
 *        yField: ['apples', 'oranges']
 *    }
 * });
 * </pre>
 * @see ext.chart.CartesianChart#flipXY
 * @see ext.chart.axis.AxisCategory
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Bar3D.html Original Ext JS documentation of 'Ext.chart.series.Bar3D'
 */
public class Bar3DSeries extends BarSeries {
  /**
   * @inheritDoc
   */
  public function Bar3DSeries(config:Bar3DSeries = null) {
    super(config);
  }

  /**
   * For 3D series, it's quite the opposite. It would be extremely odd,
   * if top segments were rendered as if they were under the bottom ones.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Bar3D.html#property-reversedSpriteZOrder Original Ext JS documentation of 'reversedSpriteZOrder'
   */
  public native function get reversedSpriteZOrder():*;

  /**
   * @private
   */
  public native function set reversedSpriteZOrder(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Custom style configuration for the sprite used in the series.
   * It overrides the style that is provided by the current theme. See
   * →<code>ext.chart.theme.series.Bar3DSeriesTheme</code>
   * @see ext.chart.theme.series.Bar3DSeriesTheme
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Bar3D.html#cfg-style Original Ext JS documentation of 'style'
   * @see #getStyle()
   * @see #setStyle()
   */
  override public native function get style():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set style(value:Object):void;

  /**
   * Returns the value of <code>style</code>.
   * @see #style
   */
  override public native function getStyle():Object;

  /**
   * Sets the value of <code>style</code>.
   * @param style The new value.
   * @see #style
   */
  override public native function setStyle(style:Object):void;
}
}