package ext.chart.series {

[Native("Ext.chart.series.Bar", require)]
/**
 * Creates a Bar or Column Chart (depending on the value of the
 * →<code>ext.chart.CartesianChart.flipXY</code> config).
 * <p>Note: 'bar' series is meant to be used with the
 * <i>'category'</i> (→<code>ext.chart.axis.AxisCategory</code>) axis as its x-axis.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'cartesian',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    store: {
 *        fields: ['name', 'value'],
 *        data: [{
 *            name: 'metric one',
 *            value: 10
 *        }, {
 *            name: 'metric two',
 *            value: 7
 *        }, {
 *            name: 'metric three',
 *            value: 5
 *        }, {
 *            name: 'metric four',
 *            value: 2
 *        }, {
 *            name: 'metric five',
 *            value: 27
 *        }]
 *    },
 *    axes: [{
 *        type: 'numeric',
 *        position: 'left',
 *        title: {
 *            text: 'Sample Values',
 *            fontSize: 15
 *        },
 *        fields: 'value'
 *    }, {
 *        type: 'category',
 *        position: 'bottom',
 *        title: {
 *            text: 'Sample Values',
 *            fontSize: 15
 *        },
 *        fields: 'name'
 *    }],
 *    series: {
 *        type: 'bar',
 *        subStyle: {
 *            fill: ['#388FAD'],
 *            stroke: '#1F6D91'
 *        },
 *        xField: 'name',
 *        yField: 'value'
 *    }
 * });
 * </pre>
 * @see ext.chart.CartesianChart#flipXY
 * @see ext.chart.axis.AxisCategory
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Bar.html Original Ext JS documentation of 'Ext.chart.series.Bar'
 */
public class BarSeries extends StackedCartesianSeries {
  /**
   * @inheritDoc
   */
  public function BarSeries(config:BarSeries = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * Custom style configuration for the sprite used in the series.
   * It overrides the style that is provided by the current theme. See
   * →<code>ext.chart.theme.series.BarSeriesTheme</code>
   * @see ext.chart.theme.series.BarSeriesTheme
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Bar.html#cfg-style Original Ext JS documentation of 'style'
   * @see #getStyle()
   * @see #setStyle()
   */
  override public native function get style():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set style(value:Object):void;

  /**
   * Returns the value of <code>style</code>.
   * @see #style
   */
  override public native function getStyle():Object;

  /**
   * Sets the value of <code>style</code>.
   * @param style The new value.
   * @see #style
   */
  override public native function setStyle(style:Object):void;
}
}