package ext.chart.series {

[Native("Ext.chart.series.BoxPlot", require)]
/**
 * A box plot chart is a useful tool for visializing data distribution within datasets.
 * For example, salary ranges for a set of occupations, or life expectancy for a set
 * of countries. A single box with whiskers displays the following values for a dataset:
 * <ul>
 * <li>minimum</li>
 * <li>lower quartile (Q1)</li>
 * <li>median (Q2)</li>
 * <li>higher quartile (Q3)</li>
 * <li>maximum</li>
 * </ul>
 * <p>For example:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'cartesian',
 *    width: 400,
 *    height: 400,
 *    renderTo: Ext.getBody(),
 *    insetPadding: '20 20 10 10',
 *    store: {
 *        data: [{
 *            category: 'Engineer IV',
 *            low: 110, q1: 130, median: 175, q3: 200, high: 225
 *        }, {
 *            category: 'Market',
 *            low: 75, q1: 125, median: 210, q3: 230, high: 255
 *        }]
 *    },
 *    axes: [
 *        {
 *            type: 'numeric',
 *            position: 'left',
 *            renderer: function (axis, text) {
 *                return '$' + text + ' K'
 *            }
 *        },
 *        {
 *            type: 'category',
 *            position: 'bottom'
 *        }
 *    ],
 *    series: {
 *        type: 'boxplot',
 *        xField: 'category',
 *        style: {
 *            maxBoxWidth: 50,
 *            lineWidth: 2
 *        }
 *    }
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.BoxPlot.html Original Ext JS documentation of 'Ext.chart.series.BoxPlot'
 */
public class BoxPlotSeries extends CartesianSeries {
  /**
   * @inheritDoc
   */
  public function BoxPlotSeries(config:BoxPlotSeries = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * The name of the store record field that represents the largest value of a dataset.
   * @default 'high'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.BoxPlot.html#cfg-highField Original Ext JS documentation of 'highField'
   * @see #getHighField()
   * @see #setHighField()
   */
  public native function get highField():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set highField(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the store record field that represents the smallest value of a dataset.
   * @default 'low'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.BoxPlot.html#cfg-lowField Original Ext JS documentation of 'lowField'
   * @see #getLowField()
   * @see #setLowField()
   */
  public native function get lowField():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set lowField(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the store record field that represents the median of a dataset.
   * @default 'median'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.BoxPlot.html#cfg-medianField Original Ext JS documentation of 'medianField'
   * @see #getMedianField()
   * @see #setMedianField()
   */
  public native function get medianField():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set medianField(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the store record field that represents the lower (1-st) quartile
   * value of a dataset.
   * @default 'q1'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.BoxPlot.html#cfg-q1Field Original Ext JS documentation of 'q1Field'
   * @see #getQ1Field()
   * @see #setQ1Field()
   */
  public native function get q1Field():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set q1Field(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the store record field that represents the upper (3-rd) quartile
   * value of a dataset.
   * @default 'q3'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.BoxPlot.html#cfg-q3Field Original Ext JS documentation of 'q3Field'
   * @see #getQ3Field()
   * @see #setQ3Field()
   */
  public native function get q3Field():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set q3Field(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Custom style configuration for the sprite used in the series.
   * It overrides the style that is provided by the current theme. See
   * →<code>ext.chart.theme.series.BoxPlotSeriesTheme</code>
   * @see ext.chart.theme.series.BoxPlotSeriesTheme
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.BoxPlot.html#cfg-style Original Ext JS documentation of 'style'
   * @see #getStyle()
   * @see #setStyle()
   */
  override public native function get style():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set style(value:Object):void;

  /**
   * Returns the value of <code>highField</code>.
   * @see #highField
   */
  public native function getHighField():String;

  /**
   * Returns the value of <code>lowField</code>.
   * @see #lowField
   */
  public native function getLowField():String;

  /**
   * Returns the value of <code>medianField</code>.
   * @see #medianField
   */
  public native function getMedianField():String;

  /**
   * Returns the value of <code>q1Field</code>.
   * @see #q1Field
   */
  public native function getQ1Field():String;

  /**
   * Returns the value of <code>q3Field</code>.
   * @see #q3Field
   */
  public native function getQ3Field():String;

  /**
   * Returns the value of <code>style</code>.
   * @see #style
   */
  override public native function getStyle():Object;

  /**
   * Sets the value of <code>highField</code>.
   * @param highField The new value.
   * @see #highField
   */
  public native function setHighField(highField:String):void;

  /**
   * Sets the value of <code>lowField</code>.
   * @param lowField The new value.
   * @see #lowField
   */
  public native function setLowField(lowField:String):void;

  /**
   * Sets the value of <code>medianField</code>.
   * @param medianField The new value.
   * @see #medianField
   */
  public native function setMedianField(medianField:String):void;

  /**
   * Sets the value of <code>q1Field</code>.
   * @param q1Field The new value.
   * @see #q1Field
   */
  public native function setQ1Field(q1Field:String):void;

  /**
   * Sets the value of <code>q3Field</code>.
   * @param q3Field The new value.
   * @see #q3Field
   */
  public native function setQ3Field(q3Field:String):void;

  /**
   * Sets the value of <code>style</code>.
   * @param style The new value.
   * @see #style
   */
  override public native function setStyle(style:Object):void;
}
}