package ext.chart.series {

[Native("Ext.chart.series.Cartesian", require)]
/**
 * Common base class for series implementations that plot values using cartesian coordinates.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Cartesian.html Original Ext JS documentation of 'Ext.chart.series.Cartesian'
 */
public class CartesianSeries extends Series {
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Cartesian.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function CartesianSeries(config:CartesianSeries = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * xAxis The chart axis the series is bound to in the 'X' direction.
   * Normally, this would be set automatically by the series.
   * For charts with multiple x-axes, this defines which x-axis is used by the series.
   * It refers to either axis' ID or the (zero-based) index of the axis
   * in the chart's →<code>ext.chart.AbstractChart.axes</code> config.
   * @default null
   * @see ext.chart.AbstractChart#axes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Cartesian.html#cfg-xAxis Original Ext JS documentation of 'xAxis'
   * @see #getXAxis()
   * @see #setXAxis()
   */
  public native function get xAxis():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set xAxis(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The field used to access the x axis value from the items from the data source.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Cartesian.html#cfg-xField Original Ext JS documentation of 'xField'
   * @see #getXField()
   * @see #setXField()
   */
  public native function get xField():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set xField(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * yAxis The chart axis the series is bound to in the 'Y' direction.
   * Normally, this would be set automatically by the series.
   * For charts with multiple y-axes, this defines which y-axis is used by the series.
   * It refers to either axis' ID or the (zero-based) index of the axis
   * in the chart's →<code>ext.chart.AbstractChart.axes</code> config.
   * @default null
   * @see ext.chart.AbstractChart#axes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Cartesian.html#cfg-yAxis Original Ext JS documentation of 'yAxis'
   * @see #getYAxis()
   * @see #setYAxis()
   */
  public native function get yAxis():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set yAxis(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The field(s) used to access the y-axis value(s) of the items from the data source.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Cartesian.html#cfg-yField Original Ext JS documentation of 'yField'
   * @see #getYField()
   * @see #setYField()
   */
  public native function get yField():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set yField(value:*):void;

  /**
   * Returns the value of <code>xAxis</code>.
   * @see #xAxis
   */
  public native function getXAxis():*;

  /**
   * Returns the value of <code>xField</code>.
   * @see #xField
   */
  public native function getXField():String;

  /**
   * Returns the value of <code>yAxis</code>.
   * @see #yAxis
   */
  public native function getYAxis():*;

  /**
   * Returns the value of <code>yField</code>.
   * @see #yField
   */
  public native function getYField():*;

  /**
   * Sets the value of <code>xAxis</code>.
   * @param xAxis The new value.
   * @see #xAxis
   */
  public native function setXAxis(xAxis:*):void;

  /**
   * Sets the value of <code>xField</code>.
   * @param xField The new value.
   * @see #xField
   */
  public native function setXField(xField:String):void;

  /**
   * Sets the value of <code>yAxis</code>.
   * @param yAxis The new value.
   * @see #yAxis
   */
  public native function setYAxis(yAxis:*):void;

  /**
   * Sets the value of <code>yField</code>.
   * @param yField The new value.
   * @see #yField
   */
  public native function setYField(yField:*):void;
}
}