package ext.chart.series {
[Native("Ext.chart.series.Gauge", require)]
/**
 * Displays a gauge chart.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'polar',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    store: {
 *        fields: ['mph', 'fuel', 'temp', 'rpm'],
 *        data: [{
 *            mph: 65,
 *            fuel: 50,
 *            temp: 150,
 *            rpm: 6000
 *        }]
 *    },
 *    series: {
 *        type: 'gauge',
 *        colors: ['#1F6D91', '#90BCC9'],
 *        angleField: 'mph',
 *        needle: true,
 *        donut: 30
 *    }
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Gauge.html Original Ext JS documentation of 'Ext.chart.series.Gauge'
 */
public class GaugeSeries extends PolarSeries {
  /**
   * @inheritDoc
   */
  public function GaugeSeries(config:GaugeSeries = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * The store record field name to be used for the gauge value.
   * The values bound to this field name must be positive real numbers.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Gauge.html#cfg-angleField Original Ext JS documentation of 'angleField'
   * @see #getAngleField()
   * @see #setAngleField()
   */
  override public native function get angleField():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set angleField(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * <b>This is a required setting</b>. An array of color values which is used for the needle and the <code>→sectors</code>.
   * @see #sectors
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Gauge.html#cfg-colors Original Ext JS documentation of 'colors'
   * @see #getColors()
   * @see #setColors()
   */
  override public native function get colors():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set colors(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * Percentage of the radius of the donut hole compared to the entire disk.
   * @default 30
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Gauge.html#cfg-donut Original Ext JS documentation of 'donut'
   * @see #getDonut()
   * @see #setDonut()
   */
  public native function get donut():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set donut(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The maximum value of the gauge.
   * @default 100
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Gauge.html#cfg-maximum Original Ext JS documentation of 'maximum'
   * @see #getMaximum()
   * @see #setMaximum()
   */
  public native function get maximum():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set maximum(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum value of the gauge.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Gauge.html#cfg-minimum Original Ext JS documentation of 'minimum'
   * @see #getMinimum()
   * @see #setMinimum()
   */
  public native function get minimum():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set minimum(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * If true, display the gauge as a needle, otherwise as a sector.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Gauge.html#cfg-needle Original Ext JS documentation of 'needle'
   * @see #getNeedle()
   * @see #setNeedle()
   */
  public native function get needle():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set needle(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Percentage of the length of needle compared to the radius of the entire disk.
   * @default 90
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Gauge.html#cfg-needleLength Original Ext JS documentation of 'needleLength'
   * @see #getNeedleLength()
   * @see #setNeedleLength()
   */
  public native function get needleLength():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set needleLength(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Width of the needle in pixels.
   * @default 4
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Gauge.html#cfg-needleWidth Original Ext JS documentation of 'needleWidth'
   * @see #getNeedleWidth()
   * @see #setNeedleWidth()
   */
  public native function get needleWidth():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set needleWidth(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Allows to paint sectors of different colors in the background of the gauge,
   * with optional labels.
   * <p>It can be an array of numbers (each between <code>→minimum</code> and <code>→maximum</code>) that
   * define the highest value of each sector. For N sectors, only (N-1) values are
   * needed because it is assumed that the first sector starts at <code>→minimum</code> and the
   * last sector ends at <code>→maximum</code>. Example: a water temperature gauge that is blue
   * below 20C, red above 80C, gray in-between, and with an orange needle...</p>
   * <pre>
   *  minimum: 0,
   *  maximum: 100,
   *  sectors: [20, 80],
   *  colors: ['orange', 'blue', 'lightgray', 'red']
   * </pre>
   * <p>It can be also an array of objects, each with the following properties:</p>
   * <ul>
   * <li><code>start:Number</code> (optional) —
   * The starting value of the sector. If omitted, it
   * uses the previous sector's <code>end</code> value or the chart's <code>→minimum</code>.
   * </li>
   * <li><code>end:Number</code> (optional) —
   * The ending value of the sector. If omitted, it uses
   * the <code>→maximum</code> defined for the chart.
   * </li>
   * <li><code>label:String</code> (optional) —
   * The label for this sector. Labels are styled using
   * the series' →<code>ext.chart.series.Series.label</code> config.
   * </li>
   * <li><code>color:String</code> (optional) —
   * The color of the sector. If omitted, it uses one
   * of the <code>→colors</code> defined for the series or for the chart.
   * </li>
   * <li><code>style:Object</code> (optional) —
   * An additional style object for the sector (for
   * instance to set the opacity or to draw a line of a different color around the
   * sector).
   * <pre>
   *  minimum: 0,
   *  maximum: 100,
   *  sectors: [{
   *          end: 20,
   *          label: 'Cold',
   *          color: 'aqua'
   *      },
   *      {
   *          end: 80,
   *          label: 'Temp.',
   *          color: 'lightgray',
   *          style: { strokeStyle:'black', strokeOpacity:1, lineWidth:1 }
   *      },
   *      {
   *          label: 'Hot',
   *          color: 'tomato'
   *      }]
   * </pre>
   * </li>
   * </ul>
   * @see #minimum
   * @see #maximum
   * @see ext.chart.series.Series#label
   * @see #colors
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Gauge.html#cfg-sectors Original Ext JS documentation of 'sectors'
   * @see #getSectors()
   * @see #setSectors()
   */
  public native function get sectors():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set sectors(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * Whether to add the gauge chart elements as legend items.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Gauge.html#cfg-showInLegend Original Ext JS documentation of 'showInLegend'
   * @see #getShowInLegend()
   * @see #setShowInLegend()
   */
  override public native function get showInLegend():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set showInLegend(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The size of the sector that the series will occupy.
   * @default Math.PI / 2
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Gauge.html#cfg-totalAngle Original Ext JS documentation of 'totalAngle'
   * @see #getTotalAngle()
   * @see #setTotalAngle()
   */
  public native function get totalAngle():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set totalAngle(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Directly sets the displayed value of the gauge.
   * It is ignored if →<code>angleField</code> is provided.
   * @default null
   * @see #angleField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Gauge.html#cfg-value Original Ext JS documentation of 'value'
   * @see #getValue()
   * @see #setValue()
   */
  public native function get value():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set value(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Indicates whether to show the whole disk
   * or only the marked part.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Gauge.html#cfg-wholeDisk Original Ext JS documentation of 'wholeDisk'
   * @see #getWholeDisk()
   * @see #setWholeDisk()
   */
  public native function get wholeDisk():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set wholeDisk(value:Boolean):void;

  /**
   * Returns the value of <code>angleField</code>.
   * @see #angleField
   */
  override public native function getAngleField():String;

  /**
   * Returns the value of <code>colors</code>.
   * @see #colors
   */
  override public native function getColors():Array;

  /**
   * Returns the value of <code>donut</code>.
   * @see #donut
   */
  public native function getDonut():Number;

  /**
   * Returns the value of <code>maximum</code>.
   * @see #maximum
   */
  public native function getMaximum():Number;

  /**
   * Returns the value of <code>minimum</code>.
   * @see #minimum
   */
  public native function getMinimum():Number;

  /**
   * Returns the value of <code>needle</code>.
   * @see #needle
   */
  public native function getNeedle():Boolean;

  /**
   * Returns the value of <code>needleLength</code>.
   * @see #needleLength
   */
  public native function getNeedleLength():Number;

  /**
   * Returns the value of <code>needleWidth</code>.
   * @see #needleWidth
   */
  public native function getNeedleWidth():Number;

  /**
   * Returns the value of <code>sectors</code>.
   * @see #sectors
   */
  public native function getSectors():Array;

  /**
   * Returns the value of <code>showInLegend</code>.
   * @see #showInLegend
   */
  override public native function getShowInLegend():Boolean;

  /**
   * Returns the value of <code>totalAngle</code>.
   * @see #totalAngle
   */
  public native function getTotalAngle():Number;

  /**
   * Returns the value of <code>value</code>.
   * @see #value
   */
  public native function getValue():Number;

  /**
   * Returns the value of <code>wholeDisk</code>.
   * @see #wholeDisk
   */
  public native function getWholeDisk():Boolean;

  /**
   * Sets the value of <code>angleField</code>.
   * @param angleField The new value.
   * @see #angleField
   */
  override public native function setAngleField(angleField:String):void;

  /**
   * Sets the value of <code>colors</code>.
   * @param colors The new value.
   * @see #colors
   */
  override public native function setColors(colors:Array):void;

  /**
   * Sets the value of <code>donut</code>.
   * @param donut The new value.
   * @see #donut
   */
  public native function setDonut(donut:Number):void;

  /**
   * Sets the value of <code>maximum</code>.
   * @param maximum The new value.
   * @see #maximum
   */
  public native function setMaximum(maximum:Number):void;

  /**
   * Sets the value of <code>minimum</code>.
   * @param minimum The new value.
   * @see #minimum
   */
  public native function setMinimum(minimum:Number):void;

  /**
   * Sets the value of <code>needle</code>.
   * @param needle The new value.
   * @see #needle
   */
  public native function setNeedle(needle:Boolean):void;

  /**
   * Sets the value of <code>needleLength</code>.
   * @param needleLength The new value.
   * @see #needleLength
   */
  public native function setNeedleLength(needleLength:Number):void;

  /**
   * Sets the value of <code>needleWidth</code>.
   * @param needleWidth The new value.
   * @see #needleWidth
   */
  public native function setNeedleWidth(needleWidth:Number):void;

  /**
   * Sets the value of <code>sectors</code>.
   * @param sectors The new value.
   * @see #sectors
   */
  public native function setSectors(sectors:Array):void;

  /**
   * Sets the value of <code>showInLegend</code>.
   * @param showInLegend The new value.
   * @see #showInLegend
   */
  override public native function setShowInLegend(showInLegend:Boolean):void;

  /**
   * Sets the value of <code>totalAngle</code>.
   * @param totalAngle The new value.
   * @see #totalAngle
   */
  public native function setTotalAngle(totalAngle:Number):void;

  /**
   * Sets the value of <code>value</code>.
   * @param value The new value.
   * @see #value
   */
  public native function setValue(value:Number):void;

  /**
   * Sets the value of <code>wholeDisk</code>.
   * @param wholeDisk The new value.
   * @see #wholeDisk
   */
  public native function setWholeDisk(wholeDisk:Boolean):void;
}
}