package ext.chart.series {

[Native("Ext.chart.series.Line", require)]
/**
 * Creates a Line Chart. A Line Chart is a useful visualization technique to display quantitative
 * information for different categories or other real values (as opposed to the bar chart),
 * that can show some progression (or regression) in the dataset.
 * As with all other series, the Line Series must be appended in the <i>series</i> Chart array
 * configuration. See the Chart documentation for more information. A typical configuration object
 * for the line series could be:
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'cartesian',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    insetPadding: 40,
 *    store: {
 *        fields: ['name', 'data1', 'data2'],
 *        data: [{
 *            'name': 'metric one',
 *            'data1': 10,
 *            'data2': 14
 *        }, {
 *            'name': 'metric two',
 *            'data1': 7,
 *            'data2': 16
 *        }, {
 *            'name': 'metric three',
 *            'data1': 5,
 *            'data2': 14
 *        }, {
 *            'name': 'metric four',
 *            'data1': 2,
 *            'data2': 6
 *        }, {
 *            'name': 'metric five',
 *            'data1': 27,
 *            'data2': 36
 *        }]
 *    },
 *    axes: [{
 *        type: 'numeric',
 *        position: 'left',
 *        fields: ['data1'],
 *        title: {
 *            text: 'Sample Values',
 *            fontSize: 15
 *        },
 *        grid: true,
 *        minimum: 0
 *    }, {
 *        type: 'category',
 *        position: 'bottom',
 *        fields: ['name'],
 *        title: {
 *            text: 'Sample Values',
 *            fontSize: 15
 *        }
 *    }],
 *    series: [{
 *        type: 'line',
 *        style: {
 *            stroke: '#30BDA7',
 *            lineWidth: 2
 *        },
 *        xField: 'name',
 *        yField: 'data1',
 *        marker: {
 *            type: 'path',
 *            path: ['M', - 4, 0, 0, 4, 4, 0, 0, - 4, 'Z'],
 *            stroke: '#30BDA7',
 *            lineWidth: 2,
 *            fill: 'white'
 *        }
 *    }, {
 *        type: 'line',
 *        fill: true,
 *        style: {
 *            fill: '#96D4C6',
 *            fillOpacity: .6,
 *            stroke: '#0A3F50',
 *            strokeOpacity: .6,
 *        },
 *        xField: 'name',
 *        yField: 'data2',
 *        marker: {
 *            type: 'circle',
 *            radius: 4,
 *            lineWidth: 2,
 *            fill: 'white'
 *        }
 *    }]
 * });
 * </pre>
 * <p>In this configuration we're adding two series (or lines), one bound to the <code>data1</code>
 * property of the store and the other to <code>data3</code>. The type for both configurations is
 * <code>line</code>. The <code>→xField</code> for both series is the same, the <code>name</code> property of the store.
 * Both line series share the same axis, the left axis. You can set particular marker
 * configuration by adding properties onto the marker object. Both series have
 * an object as highlight so that markers animate smoothly to the properties in highlight
 * when hovered. The second series has <code>fill = true</code> which means that the line will also
 * have an area below it of the same color.</p>
 * <p><b>Note:</b> In the series definition remember to explicitly set the axis to bind the
 * values of the line series to. This can be done by using the <code>axis</code> configuration property.</p>
 * @see #xField
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Line.html Original Ext JS documentation of 'Ext.chart.series.Line'
 */
public class LineSeries extends CartesianSeries {
  /**
   * @inheritDoc
   */
  public function LineSeries(config:LineSeries = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * The type of curve that connects the data points.
   * Please see <i>line sprite documentation</i> (→<code>ext.chart.series.sprite.LineSeriesSprite.curve</code>)
   * for the full description.
   * @default {
   *     type: 'linear'
   * }
   * @see ext.chart.series.sprite.LineSeriesSprite#curve
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Line.html#cfg-curve Original Ext JS documentation of 'curve'
   * @see #getCurve()
   * @see #setCurve()
   */
  public native function get curve():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set curve(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * If set to <code>true</code>, the area underneath the line is filled with the color defined
   * as follows, listed by priority...
   * <ul>
   * <li>The color that is configured for this series (→<code>ext.chart.series.Series.colors</code>).</li>
   * <li>The color that is configured for this chart (→<code>ext.chart.AbstractChart.colors</code>).</li>
   * <li>The fill color that is set in the →<code>style</code> config.</li>
   * <li>The stroke color that is set in the →<code>style</code> config, or the same color
   * as the line.</li>
   * </ul>
   * <p>Note: Do not confuse <code>series.config.fill</code> (which is a boolean) with <code>series.style.fill' (which is an alias for the</code>fillStyle<code>property and contains a color). For compatibility with previous versions of the API, if</code>config.fill<code>is undefined but a</code>style.fill' color
   * is provided, <code>config.fill</code> is considered true. So the default value below must be
   * undefined, not false.</p>
   * @default undefined
   * @see ext.chart.series.Series#colors
   * @see ext.chart.AbstractChart#colors
   * @see #style
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Line.html#cfg-fill Original Ext JS documentation of 'fill'
   * @see #getFill()
   * @see #setFill()
   */
  public native function get fill():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set fill(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Possible values:
   * 'gap' - null points are rendered as gaps.
   * 'connect' - non-null points are connected across null points, so that
   * there is no gap, unless null points are at the beginning/end of the line.
   * Only the visible data points are connected - if a visible data point
   * is followed by a series of null points that go off screen and eventually
   * terminate with a non-null point, the connection won't be made.
   * 'origin' - null data points are rendered at the origin,
   * which is the y-coordinate of a point where the x and y axes meet.
   * This requires that at least the x-coordinate of a point is a valid value.
   * @default "gap"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Line.html#cfg-nullStyle Original Ext JS documentation of 'nullStyle'
   * @see #getNullStyle()
   * @see #setNullStyle()
   */
  public native function get nullStyle():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set nullStyle(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The offset distance from the cursor position to the line series to trigger events
   * (then used for highlighting series, etc).
   * @default 20
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Line.html#cfg-selectionTolerance Original Ext JS documentation of 'selectionTolerance'
   * @see #getSelectionTolerance()
   * @see #setSelectionTolerance()
   */
  public native function get selectionTolerance():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set selectionTolerance(value:Number):void;

  [Deprecated(replacement="curve", since="6.5.0")]
  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> if the series' line should be smoothed.
   * Line smoothing only works with gapless data.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Line.html#cfg-smooth Original Ext JS documentation of 'smooth'
   * @see #getSmooth()
   * @see #setSmooth()
   */
  public native function get smooth():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set smooth(value:Boolean):void;

  [Deprecated(replacement="curve", since="6.5.0")]
  [ExtConfig]
  [Bindable]
  /**
   * If set to <code>true</code>, the line uses steps instead of straight lines to connect the dots.
   * It is ignored if <code>→smooth</code> is true.
   * @default null
   * @see #smooth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Line.html#cfg-step Original Ext JS documentation of 'step'
   * @see #getStep()
   * @see #setStep()
   */
  public native function get step():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set step(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Custom style configuration for the sprite used in the series.
   * It overrides the style that is provided by the current theme. See
   * →<code>ext.chart.theme.series.LineSeriesTheme</code>
   * @see ext.chart.theme.series.LineSeriesTheme
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Line.html#cfg-style Original Ext JS documentation of 'style'
   * @see #getStyle()
   * @see #setStyle()
   */
  override public native function get style():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set style(value:Object):void;

  /**
   * Returns the value of <code>curve</code>.
   * @see #curve
   */
  public native function getCurve():Object;

  /**
   * Returns the value of <code>fill</code>.
   * @see #fill
   */
  public native function getFill():Boolean;

  /**
   * Returns the value of <code>nullStyle</code>.
   * @see #nullStyle
   */
  public native function getNullStyle():String;

  /**
   * Returns the value of <code>selectionTolerance</code>.
   * @see #selectionTolerance
   */
  public native function getSelectionTolerance():Number;

  [Deprecated(replacement="curve", since="6.5.0")]
  /**
   * Returns the value of <code>smooth</code>.
   * @see #smooth
   */
  public native function getSmooth():Boolean;

  [Deprecated(replacement="curve", since="6.5.0")]
  /**
   * Returns the value of <code>step</code>.
   * @see #step
   */
  public native function getStep():Boolean;

  /**
   * Returns the value of <code>style</code>.
   * @see #style
   */
  override public native function getStyle():Object;

  /**
   * Sets the value of <code>curve</code>.
   * @param curve The new value.
   * @see #curve
   */
  public native function setCurve(curve:Object):void;

  /**
   * Sets the value of <code>fill</code>.
   * @param fill The new value.
   * @see #fill
   */
  public native function setFill(fill:Boolean):void;

  /**
   * Sets the value of <code>nullStyle</code>.
   * @param nullStyle The new value.
   * @see #nullStyle
   */
  public native function setNullStyle(nullStyle:String):void;

  /**
   * Sets the value of <code>selectionTolerance</code>.
   * @param selectionTolerance The new value.
   * @see #selectionTolerance
   */
  public native function setSelectionTolerance(selectionTolerance:Number):void;

  [Deprecated(replacement="curve", since="6.5.0")]
  /**
   * Sets the value of <code>smooth</code>.
   * @param smooth The new value.
   * @see #smooth
   */
  public native function setSmooth(smooth:Boolean):void;

  [Deprecated(replacement="curve", since="6.5.0")]
  /**
   * Sets the value of <code>step</code>.
   * @param step The new value.
   * @see #step
   */
  public native function setStep(step:Boolean):void;

  /**
   * Sets the value of <code>style</code>.
   * @param style The new value.
   * @see #style
   */
  override public native function setStyle(style:Object):void;
}
}