package ext.chart.series {
[Native("Ext.chart.series.Pie3D", require)]
/**
 * Creates a 3D Pie Chart.
 * <p><b>Note:</b> Labels, legends, and lines are not currently available when using the
 * 3D Pie chart series.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'polar',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    theme: 'green',
 *    interactions: 'rotate',
 *    store: {
 *        fields: ['data3'],
 *        data: [{
 *            'data3': 14
 *        }, {
 *            'data3': 16
 *        }, {
 *            'data3': 14
 *        }, {
 *            'data3': 6
 *        }, {
 *            'data3': 36
 *        }]
 *    },
 *    series: {
 *        type: 'pie3d',
 *        angleField: 'data3',
 *        donut: 30
 *    }
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie3D.html Original Ext JS documentation of 'Ext.chart.series.Pie3D'
 */
public class Pie3DSeries extends PolarSeries {
  /**
   * @inheritDoc
   */
  public function Pie3DSeries(config:Pie3DSeries = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * <b>This is a required setting</b>. The store record field name to be used for the pie angles.
   * The values bound to this field name must be positive real numbers.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie3D.html#cfg-angleField Original Ext JS documentation of 'angleField'
   * @see #getAngleField()
   * @see #setAngleField()
   */
  override public native function get angleField():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set angleField(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Specifies the radius of the donut hole, as a percentage
   * of the chart's radius.
   * Defaults to 0 (no donut hole).
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie3D.html#cfg-donut Original Ext JS documentation of 'donut'
   * @see #getDonut()
   * @see #setDonut()
   */
  public native function get donut():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set donut(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Determines which pie slices are hidden.
   * @default []
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie3D.html#cfg-hidden Original Ext JS documentation of 'hidden'
   * @see #getHidden()
   * @see #setHidden()
   */
  override public native function get hidden():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set hidden(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Default →<code>highlight</code> config for the 3D pie series.
   * Slides highlighted pie sector outward.
   * @default {
   *     margin: 20
   * }
   * @see #highlight
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie3D.html#cfg-highlightCfg Original Ext JS documentation of 'highlightCfg'
   * @see #getHighlightCfg()
   * @see #setHighlightCfg()
   */
  override public native function get highlightCfg():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set highlightCfg(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The starting angle of the pie slices.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie3D.html#cfg-rotation Original Ext JS documentation of 'rotation'
   * @see #getRotation()
   * @see #setRotation()
   */
  override public native function get rotation():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set rotation(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Custom style configuration for the sprite used in the series.
   * It overrides the style that is provided by the current theme. See
   * →<code>ext.chart.theme.series.Pie3DSeriesTheme</code>
   * @see ext.chart.theme.series.Pie3DSeriesTheme
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie3D.html#cfg-style Original Ext JS documentation of 'style'
   * @see #getStyle()
   * @see #setStyle()
   */
  override public native function get style():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set style(value:Object):void;

  /**
   * Returns the value of <code>angleField</code>.
   * @see #angleField
   */
  override public native function getAngleField():String;

  /**
   * Returns the value of <code>donut</code>.
   * @see #donut
   */
  public native function getDonut():Number;

  /**
   * Returns the value of <code>hidden</code>.
   * @see #hidden
   */
  override public native function getHidden():*;

  /**
   * Returns the value of <code>highlightCfg</code>.
   * @see #highlightCfg
   */
  override public native function getHighlightCfg():Object;

  /**
   * Returns the value of <code>rotation</code>.
   * @see #rotation
   */
  override public native function getRotation():Number;

  /**
   * Returns the value of <code>style</code>.
   * @see #style
   */
  override public native function getStyle():Object;

  /**
   * Sets the value of <code>angleField</code>.
   * @param angleField The new value.
   * @see #angleField
   */
  override public native function setAngleField(angleField:String):void;

  /**
   * Sets the value of <code>donut</code>.
   * @param donut The new value.
   * @see #donut
   */
  public native function setDonut(donut:Number):void;

  /**
   * Sets the value of <code>hidden</code>.
   * @param hidden The new value.
   * @see #hidden
   */
  override public native function setHidden(hidden:*):void;

  /**
   * Sets the value of <code>highlightCfg</code>.
   * @param highlightCfg The new value.
   * @see #highlightCfg
   */
  override public native function setHighlightCfg(highlightCfg:Object):void;

  /**
   * Sets the value of <code>rotation</code>.
   * @param rotation The new value.
   * @see #rotation
   */
  override public native function setRotation(rotation:Number):void;

  /**
   * Sets the value of <code>style</code>.
   * @param style The new value.
   * @see #style
   */
  override public native function setStyle(style:Object):void;
}
}