package ext.chart.series {
[Native("Ext.chart.series.Pie", require)]
/**
 * Creates a Pie Chart. A Pie Chart is a useful visualization technique to display
 * quantitative information for different categories that also have a meaning as a whole.
 * As with all other series, the Pie Series must be appended in the <i>series</i> Chart array
 * configuration. See the Chart documentation for more information. A typical configuration
 * object for the pie series could be:
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'polar',
 *    renderTo: document.body,
 *    width: 400,
 *    height: 400,
 *    theme: 'green',
 *    interactions: ['rotate', 'itemhighlight'],
 *    store: {
 *        fields: ['name', 'data1'],
 *        data: [{
 *            name: 'metric one',
 *            data1: 14
 *        }, {
 *            name: 'metric two',
 *            data1: 16
 *        }, {
 *            name: 'metric three',
 *            data1: 14
 *        }, {
 *            name: 'metric four',
 *            data1: 6
 *        }, {
 *            name: 'metric five',
 *            data1: 36
 *        }]
 *    },
 *    series: {
 *        type: 'pie',
 *        highlight: true,
 *        angleField: 'data1',
 *        label: {
 *            field: 'name',
 *            display: 'rotate'
 *        },
 *        donut: 30
 *    }
 * });
 * </pre>
 * <p>In this configuration we set <code>pie</code> as the type for the series, then set the <code>→highlight</code> config
 * to <code>true</code> (we can also specify an object with specific style properties for highlighting options)
 * which is triggered when hovering or tapping elements.
 * We set <code>data1</code> as the value of the <code>→angleField</code> to determine the angular span for each pie slice.
 * We also set a label configuration object where we set the name of the store field
 * to be rendered as text for the label. The labels will also be displayed rotated.
 * And finally, we specify the donut hole radius for the pie series in percentages of the series
 * radius.</p>
 * @see #highlight
 * @see #angleField
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie.html Original Ext JS documentation of 'Ext.chart.series.Pie'
 */
public class PieSeries extends PolarSeries {
  /**
   * @inheritDoc
   */
  public function PieSeries(config:PieSeries = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * Whether the pie slices are displayed clockwise. Default's true.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie.html#cfg-clockwise Original Ext JS documentation of 'clockwise'
   * @see #getClockwise()
   * @see #setClockwise()
   */
  public native function get clockwise():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set clockwise(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Specifies the radius of the donut hole, as a percentage
   * of the chart's radius.
   * Defaults to 0 (no donut hole).
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie.html#cfg-donut Original Ext JS documentation of 'donut'
   * @see #getDonut()
   * @see #setDonut()
   */
  public native function get donut():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set donut(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Determines which pie slices are hidden.
   * @default []
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie.html#cfg-hidden Original Ext JS documentation of 'hidden'
   * @see #getHidden()
   * @see #setHidden()
   */
  override public native function get hidden():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set hidden(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Default highlight config for the pie series.
   * Slides highlighted pie sector outward by default.
   * <p>highlightCfg accepts as its value a config object (or array of configs) for a
   * <i>pie sprite</i> (→<code>ext.chart.series.sprite.PieSliceSprite</code>).</p>
   * <p>Example config:</p>
   * <pre>
   * Ext.create('Ext.chart.PolarChart', {
   *     renderTo: document.body,
   *     width: 600,
   *     height: 400,
   *     innerPadding: 5,
   *     store: {
   *         fields: ['name', 'data1'],
   *         data: [{
   *             name: 'metric one',
   *             data1: 10
   *         }, {
   *             name: 'metric two',
   *             data1: 7
   *         }, {
   *             name: 'metric three',
   *             data1: 5
   *         }]
   *     },
   *     series: {
   *         type: 'pie',
   *         label: {
   *             field: 'name',
   *             display: 'rotate'
   *         },
   *         xField: 'data1',
   *         donut: 30,
   *         highlightCfg: {
   *             margin: 10,
   *             fillOpacity: .7
   *         }
   *     }
   * });
   * </pre>
   * @default {
   *     margin: 20
   * }
   * @see ext.chart.series.sprite.PieSliceSprite
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie.html#cfg-highlightCfg Original Ext JS documentation of 'highlightCfg'
   * @see #getHighlightCfg()
   * @see #setHighlightCfg()
   */
  override public native function get highlightCfg():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set highlightCfg(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Allows adjustment of the radius
   * by a specific percentage.
   * @default 100
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie.html#cfg-radiusFactor Original Ext JS documentation of 'radiusFactor'
   * @see #getRadiusFactor()
   * @see #setRadiusFactor()
   */
  public native function get radiusFactor():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set radiusFactor(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The store record field name to be used for the pie slice lengths.
   * The values bound to this field name must be positive real numbers.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie.html#cfg-radiusField Original Ext JS documentation of 'radiusField'
   * @see #getRadiusField()
   * @see #setRadiusField()
   */
  override public native function get radiusField():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set radiusField(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The starting angle of the pie slices.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie.html#cfg-rotation Original Ext JS documentation of 'rotation'
   * @see #getRotation()
   * @see #setRotation()
   */
  override public native function get rotation():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set rotation(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Custom style configuration for the sprite used in the series.
   * It overrides the style that is provided by the current theme. See
   * →<code>ext.chart.theme.series.PieSeriesTheme</code>
   * @see ext.chart.theme.series.PieSeriesTheme
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie.html#cfg-style Original Ext JS documentation of 'style'
   * @see #getStyle()
   * @see #setStyle()
   */
  override public native function get style():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set style(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The total angle of the pie series.
   * @default 2&#42;PI
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie.html#cfg-totalAngle Original Ext JS documentation of 'totalAngle'
   * @see #getTotalAngle()
   * @see #setTotalAngle()
   */
  public native function get totalAngle():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set totalAngle(value:Number):void;

  /**
   * Returns the value of <code>clockwise</code>.
   * @see #clockwise
   */
  public native function getClockwise():Boolean;

  /**
   * Returns the value of <code>donut</code>.
   * @see #donut
   */
  public native function getDonut():Number;

  /**
   * Returns the value of <code>hidden</code>.
   * @see #hidden
   */
  override public native function getHidden():*;

  /**
   * Returns the value of <code>highlightCfg</code>.
   * @see #highlightCfg
   */
  override public native function getHighlightCfg():Object;

  /**
   * Returns the pie slice for a given angle
   * @param angle The angle to search for the slice
   * @return An object containing the reocord, sprite, scope etc.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Pie.html#method-getItemForAngle Original Ext JS documentation of 'getItemForAngle'
   */
  public native function getItemForAngle(angle:Number):Object;

  /**
   * Returns the value of <code>radiusFactor</code>.
   * @see #radiusFactor
   */
  public native function getRadiusFactor():Number;

  /**
   * Returns the value of <code>radiusField</code>.
   * @see #radiusField
   */
  override public native function getRadiusField():String;

  /**
   * Returns the value of <code>rotation</code>.
   * @see #rotation
   */
  override public native function getRotation():Number;

  /**
   * Returns the value of <code>style</code>.
   * @see #style
   */
  override public native function getStyle():Object;

  /**
   * Returns the value of <code>totalAngle</code>.
   * @see #totalAngle
   */
  public native function getTotalAngle():Number;

  /**
   * Sets the value of <code>clockwise</code>.
   * @param clockwise The new value.
   * @see #clockwise
   */
  public native function setClockwise(clockwise:Boolean):void;

  /**
   * Sets the value of <code>donut</code>.
   * @param donut The new value.
   * @see #donut
   */
  public native function setDonut(donut:Number):void;

  /**
   * Sets the value of <code>hidden</code>.
   * @param hidden The new value.
   * @see #hidden
   */
  override public native function setHidden(hidden:*):void;

  /**
   * Sets the value of <code>highlightCfg</code>.
   * @param highlightCfg The new value.
   * @see #highlightCfg
   */
  override public native function setHighlightCfg(highlightCfg:Object):void;

  /**
   * Sets the value of <code>radiusFactor</code>.
   * @param radiusFactor The new value.
   * @see #radiusFactor
   */
  public native function setRadiusFactor(radiusFactor:Number):void;

  /**
   * Sets the value of <code>radiusField</code>.
   * @param radiusField The new value.
   * @see #radiusField
   */
  override public native function setRadiusField(radiusField:String):void;

  /**
   * Sets the value of <code>rotation</code>.
   * @param rotation The new value.
   * @see #rotation
   */
  override public native function setRotation(rotation:Number):void;

  /**
   * Sets the value of <code>style</code>.
   * @param style The new value.
   * @see #style
   */
  override public native function setStyle(style:Object):void;

  /**
   * Sets the value of <code>totalAngle</code>.
   * @param totalAngle The new value.
   * @see #totalAngle
   */
  public native function setTotalAngle(totalAngle:Number):void;
}
}