package ext.chart.series {
[Native("Ext.chart.series.Polar", require)]
/**
 * Common base class for series implementations that plot values using polar coordinates.
 * <p>Polar charts accept angles in radians. You can calculate radians with the following
 * formula:</p>
 * <pre>
 *  radians = degrees x Π/180
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Polar.html Original Ext JS documentation of 'Ext.chart.series.Polar'
 */
public class PolarSeries extends Series {
  /**
   * @inheritDoc
   */
  public function PolarSeries(config:PolarSeries = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * The store record field name for the angular axes in radar charts,
   * or the size of the slices in pie charts.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Polar.html#cfg-angleField Original Ext JS documentation of 'angleField'
   * @see #getAngleField()
   * @see #setAngleField()
   */
  public native function get angleField():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set angleField(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * for the polar series.
   * @default [
   *     0,
   *     0
   * ]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Polar.html#cfg-center Original Ext JS documentation of 'center'
   * @see #getCenter()
   * @see #setCenter()
   */
  public native function get center():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set center(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * The x-offset of center of the polar series related to the center of the boundary.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Polar.html#cfg-offsetX Original Ext JS documentation of 'offsetX'
   * @see #getOffsetX()
   * @see #setOffsetX()
   */
  public native function get offsetX():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set offsetX(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The y-offset of center of the polar series related to the center of the boundary.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Polar.html#cfg-offsetY Original Ext JS documentation of 'offsetY'
   * @see #getOffsetY()
   * @see #setOffsetY()
   */
  public native function get offsetY():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set offsetY(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The store record field name for the radial axes in radar charts,
   * or the radius of the slices in pie charts.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Polar.html#cfg-radiusField Original Ext JS documentation of 'radiusField'
   * @see #getRadiusField()
   * @see #setRadiusField()
   */
  public native function get radiusField():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set radiusField(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The angle in radians at which the first polar series item should start.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Polar.html#cfg-rotation Original Ext JS documentation of 'rotation'
   * @see #getRotation()
   * @see #setRotation()
   */
  public native function get rotation():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set rotation(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Whether to add the series elements as legend items.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Polar.html#cfg-showInLegend Original Ext JS documentation of 'showInLegend'
   * @see #getShowInLegend()
   * @see #setShowInLegend()
   */
  override public native function get showInLegend():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set showInLegend(value:Boolean):void;

  /**
   * Returns the value of <code>angleField</code>.
   * @see #angleField
   */
  public native function getAngleField():String;

  /**
   * Returns the value of <code>center</code>.
   * @see #center
   */
  public native function getCenter():Array;

  /**
   * Returns the value of <code>offsetX</code>.
   * @see #offsetX
   */
  public native function getOffsetX():Number;

  /**
   * Returns the value of <code>offsetY</code>.
   * @see #offsetY
   */
  public native function getOffsetY():Number;

  /**
   * Returns the value of <code>radiusField</code>.
   * @see #radiusField
   */
  public native function getRadiusField():String;

  /**
   * Returns the value of <code>rotation</code>.
   * @see #rotation
   */
  public native function getRotation():Number;

  /**
   * Returns the value of <code>showInLegend</code>.
   * @see #showInLegend
   */
  override public native function getShowInLegend():Boolean;

  /**
   * Sets the value of <code>angleField</code>.
   * @param angleField The new value.
   * @see #angleField
   */
  public native function setAngleField(angleField:String):void;

  /**
   * Sets the value of <code>center</code>.
   * @param center The new value.
   * @see #center
   */
  public native function setCenter(center:Array):void;

  /**
   * Sets the value of <code>offsetX</code>.
   * @param offsetX The new value.
   * @see #offsetX
   */
  public native function setOffsetX(offsetX:Number):void;

  /**
   * Sets the value of <code>offsetY</code>.
   * @param offsetY The new value.
   * @see #offsetY
   */
  public native function setOffsetY(offsetY:Number):void;

  /**
   * Sets the value of <code>radiusField</code>.
   * @param radiusField The new value.
   * @see #radiusField
   */
  public native function setRadiusField(radiusField:String):void;

  /**
   * Sets the value of <code>rotation</code>.
   * @param rotation The new value.
   * @see #rotation
   */
  public native function setRotation(rotation:Number):void;

  /**
   * Sets the value of <code>showInLegend</code>.
   * @param showInLegend The new value.
   * @see #showInLegend
   */
  override public native function setShowInLegend(showInLegend:Boolean):void;
}
}