package ext.chart.series {
[Native("Ext.chart.series.Radar", require)]
/**
 * Creates a Radar Chart. A Radar Chart is a useful visualization technique for comparing different
 * quantitative values for a constrained number of categories.
 * As with all other series, the Radar series must be appended in the <i>series</i> Chart array
 * configuration. See the Chart documentation for more information. A typical configuration object
 * for the radar series could be:
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'polar',
 *    renderTo: document.body,
 *    width: 500,
 *    height: 400,
 *    interactions: 'rotate',
 *    store: {
 *        fields: ['name', 'data1'],
 *        data: [{
 *            'name': 'metric one',
 *            'data1': 8
 *        }, {
 *            'name': 'metric two',
 *            'data1': 10
 *        }, {
 *            'name': 'metric three',
 *            'data1': 12
 *        }, {
 *            'name': 'metric four',
 *            'data1': 1
 *        }, {
 *            'name': 'metric five',
 *            'data1': 13
 *        }]
 *    },
 *    series: {
 *        type: 'radar',
 *        angleField: 'name',
 *        radiusField: 'data1',
 *        style: {
 *            fillStyle: '#388FAD',
 *            fillOpacity: .1,
 *            strokeStyle: '#388FAD',
 *            strokeOpacity: .8,
 *            lineWidth: 1
 *        }
 *    },
 *    axes: [{
 *        type: 'numeric',
 *        position: 'radial',
 *        fields: 'data1',
 *        style: {
 *            estStepSize: 10
 *        },
 *        grid: true
 *    }, {
 *        type: 'category',
 *        position: 'angular',
 *        fields: 'name',
 *        style: {
 *            estStepSize: 1
 *        },
 *        grid: true
 *    }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Radar.html Original Ext JS documentation of 'Ext.chart.series.Radar'
 */
public class RadarSeries extends PolarSeries {
  /**
   * @inheritDoc
   */
  public function RadarSeries(config:RadarSeries = null) {
    super(config);
  }
}
}