package ext.chart.series {

[Native("Ext.chart.series.Scatter", require)]
/**
 * Creates a Scatter Chart. The scatter plot is useful when trying to display more than
 * two variables in the same visualization. These variables can be mapped into x, y coordinates
 * and also to an element's radius/size, color, etc. As with all other series, the Scatter Series
 * must be appended in the <i>series</i> Chart array configuration. See the Chart documentation for more
 * information on creating charts. A typical configuration object for the scatter could be:
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'cartesian',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    insetPadding: 40,
 *    interactions: ['itemhighlight'],
 *    store: {
 *        fields: ['name', 'data1', 'data2'],
 *        data: [{
 *            'name': 'metric one',
 *            'data1': 10,
 *            'data2': 14
 *        }, {
 *            'name': 'metric two',
 *            'data1': 7,
 *            'data2': 16
 *        }, {
 *            'name': 'metric three',
 *            'data1': 5,
 *            'data2': 14
 *        }, {
 *            'name': 'metric four',
 *            'data1': 2,
 *            'data2': 6
 *        }, {
 *            'name': 'metric five',
 *            'data1': 27,
 *            'data2': 36
 *        }]
 *    },
 *    axes: [{
 *        type: 'numeric',
 *        position: 'left',
 *        fields: ['data1'],
 *        title: {
 *            text: 'Sample Values',
 *            fontSize: 15
 *        },
 *        grid: true,
 *        minimum: 0
 *    }, {
 *        type: 'category',
 *        position: 'bottom',
 *        fields: ['name'],
 *        title: {
 *            text: 'Sample Values',
 *            fontSize: 15
 *        }
 *    }],
 *    series: {
 *        type: 'scatter',
 *        highlight: {
 *            size: 12,
 *            radius: 12,
 *            fill: '#96D4C6',
 *            stroke: '#30BDA7'
 *        },
 *        fill: true,
 *        xField: 'name',
 *        yField: 'data2',
 *        marker: {
 *            type: 'circle',
 *            fill: '#30BDA7',
 *            radius: 10,
 *            lineWidth: 0
 *        }
 *    }
 * });
 * </pre>
 * <p>In this configuration we add three different categories of scatter series. Each of them is bound
 * to a different field of the same data store, <code>data1</code>, <code>data2</code> and <code>data3</code> respectively.
 * All x-fields for the series must be the same field, in this case <code>name</code>. Each scatter series
 * has a different styling configuration for markers, specified by the <code>→marker</code> object. Finally
 * we set the left axis as axis to show the current values of the elements.</p>
 * @see #marker
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Scatter.html Original Ext JS documentation of 'Ext.chart.series.Scatter'
 */
public class ScatterSeries extends CartesianSeries {
  /**
   * @inheritDoc
   */
  public function ScatterSeries(config:ScatterSeries = null) {
    super(config);
  }
}
}