package ext.chart.series {
import ext.app.ViewController;
import ext.app.ViewModel;
import ext.data.Session;
import ext.draw.Surface;
import ext.mixin.IBindable;
import ext.mixin.Observable;

[Native("Ext.chart.series.Series", require)]
[ExtConfig]
/**
 * @see ext.chart.series.events.Series_chart_seriesEvent.CHART_ATTACHED
 * @eventType ext.chart.series.events.Series_chart_seriesEvent.CHART_ATTACHED
 */
[Event(name='onChartAttached', type='ext.chart.series.events.Series_chart_seriesEvent')]
/**
 * @see ext.chart.series.events.Series_chart_seriesEvent.CHART_DETACHED
 * @eventType ext.chart.series.events.Series_chart_seriesEvent.CHART_DETACHED
 */
[Event(name='onChartDetached', type='ext.chart.series.events.Series_chart_seriesEvent')]
/**
 * @see ext.chart.series.events.Series_item_eventEvent.ITEM_CLICK
 * @eventType ext.chart.series.events.Series_item_eventEvent.ITEM_CLICK
 */
[Event(name='onItemClick', type='ext.chart.series.events.Series_item_eventEvent')]
/**
 * @see ext.chart.series.events.Series_item_eventEvent.ITEM_DBLCLICK
 * @eventType ext.chart.series.events.Series_item_eventEvent.ITEM_DBLCLICK
 */
[Event(name='onItemDblclick', type='ext.chart.series.events.Series_item_eventEvent')]
/**
 * @see ext.chart.series.events.Series_item_eventEvent.ITEM_MOUSE_DOWN
 * @eventType ext.chart.series.events.Series_item_eventEvent.ITEM_MOUSE_DOWN
 */
[Event(name='onItemMouseDown', type='ext.chart.series.events.Series_item_eventEvent')]
/**
 * @see ext.chart.series.events.Series_item_eventEvent.ITEM_MOUSE_MOVE
 * @eventType ext.chart.series.events.Series_item_eventEvent.ITEM_MOUSE_MOVE
 */
[Event(name='onItemMouseMove', type='ext.chart.series.events.Series_item_eventEvent')]
/**
 * @see ext.chart.series.events.Series_item_eventEvent.ITEM_MOUSE_OUT
 * @eventType ext.chart.series.events.Series_item_eventEvent.ITEM_MOUSE_OUT
 */
[Event(name='onItemMouseOut', type='ext.chart.series.events.Series_item_eventEvent')]
/**
 * @see ext.chart.series.events.Series_item_eventEvent.ITEM_MOUSE_OVER
 * @eventType ext.chart.series.events.Series_item_eventEvent.ITEM_MOUSE_OVER
 */
[Event(name='onItemMouseOver', type='ext.chart.series.events.Series_item_eventEvent')]
/**
 * @see ext.chart.series.events.Series_item_eventEvent.ITEM_MOUSE_UP
 * @eventType ext.chart.series.events.Series_item_eventEvent.ITEM_MOUSE_UP
 */
[Event(name='onItemMouseUp', type='ext.chart.series.events.Series_item_eventEvent')]
/**
 * @see ext.chart.series.events.Series_item_eventEvent.ITEM_TAP
 * @eventType ext.chart.series.events.Series_item_eventEvent.ITEM_TAP
 */
[Event(name='onItemTap', type='ext.chart.series.events.Series_item_eventEvent')]
/**
 * @see ext.chart.series.events.Series_newStore_oldStoreEvent.STORE_CHANGE
 * @eventType ext.chart.series.events.Series_newStore_oldStoreEvent.STORE_CHANGE
 */
[Event(name='onStoreChange', type='ext.chart.series.events.Series_newStore_oldStoreEvent')]
/**
 * Series is the abstract class containing the common logic to all chart series.
 * Series includes methods from Labels, Highlights, and Callouts mixins. This class
 * implements the logic of animating, hiding, showing all elements and returning the
 * color of the series to be used as a legend item.
 * <p><b><i>Listeners</i></b></p>
 * <p>The series class supports listeners via the Observable syntax.</p>
 * <p>For example:</p>
 * <pre>
 * Ext.create('Ext.chart.CartesianChart', {
 *     plugins: {
 *         chartitemevents: {
 *             moveEvents: true
 *         }
 *     },
 *     store: {
 *         fields: ['pet', 'households', 'total'],
 *         data: [
 *             {pet: 'Cats', households: 38, total: 93},
 *             {pet: 'Dogs', households: 45, total: 79},
 *             {pet: 'Fish', households: 13, total: 171}
 *         ]
 *     },
 *     axes: [{
 *         type: 'numeric',
 *         position: 'left'
 *     }, {
 *         type: 'category',
 *         position: 'bottom'
 *     }],
 *     series: [{
 *         type: 'bar',
 *         xField: 'pet',
 *         yField: 'households',
 *         listeners: {
 *             itemmousemove: function (series, item, event) {
 *                 console.log('itemmousemove', item.category, item.field);
 *             }
 *         }
 *     }, {
 *         type: 'line',
 *         xField: 'pet',
 *         yField: 'total',
 *         marker: true
 *     }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html Original Ext JS documentation of 'Ext.chart.series.Series'
 */
public class Series extends Observable implements IBindable {
  /**
   * @inheritDoc
   */
  public function Series(config:Series = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The series animation configuration.
   * By default, the series is using the same animation the chart uses,
   * if it's own animation is not explicitly configured.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-animation Original Ext JS documentation of 'animation'
   * @see #getAnimation()
   * @see #setAnimation()
   */
  public native function get animation():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set animation(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Sets the background of the surface the series is attached.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-background Original Ext JS documentation of 'background'
   * @see #getBackground()
   * @see #setBackground()
   */
  public native function get background():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set background(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Setting this config option adds or removes data bindings for other configs.
   * For example, to bind the <code>title</code> config:
   * <pre>
   *  var panel = Ext.create({
   *      xtype: 'panel',
   *      bind: {
   *          title: 'Hello {user.name}'
   *      }
   *  });
   * </pre>
   * <p>To dynamically add bindings:</p>
   * <pre>
   *  panel.setBind({
   *      title: 'Greetings {user.name}!'
   *  });
   * </pre>
   * <p>To remove bindings:</p>
   * <pre>
   *  panel.setBind({
   *      title: null
   *  });
   * </pre>
   * <p>The bind expressions are presented to <code>→ext.app.ViewModel.bind()</code>. The
   * <code>ViewModel</code> instance is determined by <code>→lookupViewModel()</code>.</p>
   * <p><b>Note:</b> If bind is passed as a string, it will use the
   * →<code>ext.Component.defaultBindProperty</code> for the binding.</p>
   * @default null
   * @see ext.app.ViewModel#bind()
   * @see #lookupViewModel()
   * @see ext.Component#defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-bind Original Ext JS documentation of 'bind'
   * @see #getBind()
   * @see #setBind()
   */
  public native function get bind():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set bind(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * An array of color values which is used, in order of appearance, by the series.
   * Each series can request one or more colors from the array. Radar, Scatter or Line charts
   * require just one color each. Candlestick and OHLC require two
   * (1 for drops + 1 for rises). Pie charts and Stacked charts (like Bar or Pie charts)
   * require one color for each data category they represent, so one color for each slice
   * of a Pie chart or each segment (not bar) of a Bar chart.
   * It overrides the colors that are provided by the current theme.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-colors Original Ext JS documentation of 'colors'
   * @see #getColors()
   * @see #setColors()
   */
  public native function get colors():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set colors(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * A string alias, a configuration object or an instance of a <code>ViewController</code> for
   * this container. Sample usage:
   * <pre>
   * Ext.define('MyApp.UserController', {
   *     alias: 'controller.user'
   * });
   *
   * Ext.define('UserContainer', {
   *     extend: 'Ext.container.container',
   *     controller: 'user'
   * });
   * // Or
   * Ext.define('UserContainer', {
   *     extend: 'Ext.container.container',
   *     controller: {
   *         type: 'user',
   *         someConfig: true
   *     }
   * });
   *
   * // Can also instance at runtime
   * var ctrl = new MyApp.UserController();
   * var view = new UserContainer({
   *     controller: ctrl
   * });
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-controller Original Ext JS documentation of 'controller'
   * @see #getController()
   * @see #setController()
   */
  public native function get controller():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set controller(value:*):void;

  /**
   * This property is used to determine the property of a <code>→bind</code> config that is just
   * the value. For example, if <code>defaultBindProperty="value"</code>, then this shorthand
   * <code>→bind</code> config:
   * <pre>
   *  bind: '{name}'
   * </pre>
   * <p>Is equivalent to this object form:</p>
   * <pre>
   *  bind: {
   *      value: '{name}'
   *  }
   * </pre>
   * <p>The <code>→defaultBindProperty</code> is set to "value" for form fields and to "store" for
   * grids and trees.</p>
   * @see #bind
   * @see #defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#property-defaultBindProperty Original Ext JS documentation of 'defaultBindProperty'
   */
  public native function get defaultBindProperty():String;

  /**
   * @private
   */
  public native function set defaultBindProperty(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * If <code>true</code>, this component will be the default scope (this pointer) for events
   * specified with string names so that the scope can be dynamically resolved. The
   * component will automatically become the defaultListenerScope if a
   * →<code>controller</code> is specified.
   * <p>See the introductory docs for →<code>ext.container.Container</code> for some sample
   * usages.</p>
   * <p><b>NOTE</b>: This value can only be reliably set at construction time. Setting it
   * after that time may not correctly rewire all of the potentially effected
   * listeners.</p>
   * @default false
   * @see #controller
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-defaultListenerScope Original Ext JS documentation of 'defaultListenerScope'
   * @see #getDefaultListenerScope()
   * @see #setDefaultListenerScope()
   */
  public native function get defaultListenerScope():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set defaultListenerScope(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-hidden Original Ext JS documentation of 'hidden'
   * @see #getHidden()
   * @see #setHidden()
   */
  public native function get hidden():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set hidden(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The sprite attributes that will be applied to the highlighted items in the series.
   * If set to 'true', the default highlight style from →<code>highlightCfg</code> will be used.
   * If the value of this config is an object, it will be merged with the
   * →<code>highlightCfg</code>. In case merging of 'highlight' and 'highlightCfg' configs
   * in not the desired behavior, provide the 'highlightCfg' instead.
   * @default false
   * @see #highlightCfg
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-highlight Original Ext JS documentation of 'highlight'
   * @see #getHighlight()
   * @see #setHighlight()
   */
  public native function get highlight():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set highlight(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The default style for the highlighted item.
   * Used when →<code>highlight</code> config was simply set to 'true' instead of specifying
   * a style.
   * @default {
   *     fillStyle: 'yellow',
   *     strokeStyle: 'red'
   * }
   * @see #highlight
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-highlightCfg Original Ext JS documentation of 'highlightCfg'
   * @see #getHighlightCfg()
   * @see #setHighlightCfg()
   */
  public native function get highlightCfg():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set highlightCfg(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The sprite template used to create sprite instances in the series.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-itemInstancing Original Ext JS documentation of 'itemInstancing'
   * @see #getItemInstancing()
   * @see #setItemInstancing()
   */
  public native function get itemInstancing():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set itemInstancing(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Object with the following properties:
   * <ul>
   * <li><code>display:String</code> (optional) —
   * Specifies the presence and position of the labels.
   * The possible values depend on the series type.
   * For Line and Scatter series: 'under' | 'over' | 'rotate'.
   * For Bar and 3D Bar series: 'insideStart' | 'insideEnd' | 'outside'.
   * For Pie series: 'inside' | 'outside' | 'rotate' | 'horizontal' | 'vertical'.
   * Area, Radar and Candlestick series don't support labels.
   * For Area and Radar series please consider using <i>tooltips</i> (→<code>tooltip</code>) instead.
   * 3D Pie series currently always display labels 'outside'.
   * For all series: 'none' hides the labels.
   * <p>Default value: 'none'.</p>
   * </li>
   * <li><code>color:String</code> (optional) —
   * The color of the label text.
   * <p>Default value: '#000' (black).</p>
   * </li>
   * <li><code>field</code> (optional) —
   * The name(s) of the field(s) to be displayed in the labels. If your chart has 3 series
   * that correspond to the fields 'a', 'b', and 'c' of your model, and you only want to
   * display labels for the series 'c', you must still provide an array <code>[null, null, 'c']</code>.
   * <p>Default value: null.</p>
   * </li>
   * <li><code>font:String</code> (optional) —
   * The font used for the labels.
   * <p>Default value: '14px Helvetica'.</p>
   * </li>
   * <li><code>orientation:String</code> (optional) —
   * Either 'horizontal' or 'vertical'. If not set (default), the orientation is inferred
   * from the value of the flipXY property of the series.
   * <p>Default value: ''.</p>
   * </li>
   * <li><code>renderer:Function</code> (optional) —
   * Optional function for formatting the label into a displayable value.
   * <p>The arguments to the method are:</p>
   * <ul>
   * <li>
   * <p><i><code>text</code></i>, <i><code>sprite</code></i>, <i><code>config</code></i>, <i><code>rendererData</code></i>, <i><code>index</code></i></p>
   * <p>Label's renderer is passed the same arguments as →<code>renderer</code>
   * plus one extra 'text' argument which comes first.</p>
   * </li>
   * </ul>
   * </li>
   * <li><code>null</code> —
   * The attributes that have been changed or added,
   * or the text for the label.
   * Example to enclose every other label in parentheses:
   * <pre>
   *  renderer: function (text) {
   *      if (index % 2 == 0) {
   *          return '(' + text + ')'
   *      }
   *  }
   * </pre>
   * </li>
   * </ul>
   * @see #tooltip
   * @see #renderer
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-label Original Ext JS documentation of 'label'
   * @see #getLabel()
   * @see #setLabel()
   */
  public native function get label():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set label(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Extra distance value for which the labelOverflow listener is triggered.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-labelOverflowPadding Original Ext JS documentation of 'labelOverflowPadding'
   * @see #getLabelOverflowPadding()
   * @see #setLabelOverflowPadding()
   */
  public native function get labelOverflowPadding():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set labelOverflowPadding(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The sprite template used by marker instances on the series.
   * If the value of the marker config is set to <code>true</code> or the type
   * of the sprite instance is not specified, the →<code>ext.draw.sprite.CircleSprite</code>
   * sprite will be used.
   * <p>Examples:</p>
   * <pre>
   * marker: true
   *
   * marker: {
   *     radius: 8
   * }
   *
   * marker: {
   *     type: 'arrow',
   *     animation: {
   *         duration: 200,
   *         easing: 'backOut'
   *     }
   * }
   * </pre>
   * @default null
   * @see ext.draw.sprite.CircleSprite
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-marker Original Ext JS documentation of 'marker'
   * @see #getMarker()
   * @see #setMarker()
   */
  public native function get marker():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set marker(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * This is cyclic used if series have multiple marker sprites.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-markerSubStyle Original Ext JS documentation of 'markerSubStyle'
   * @see #getMarkerSubStyle()
   * @see #setMarkerSubStyle()
   */
  public native function get markerSubStyle():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set markerSubStyle(value:Object):void;

  [ExtConfig]
  /**
   * Set to <code>true</code> for this component's <code>name</code> property to be tracked by its containing
   * <code>nameHolder</code>.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-nameable Original Ext JS documentation of 'nameable'
   */
  public native function get nameable():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set nameable(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The surface used to render series labels.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-overlaySurface Original Ext JS documentation of 'overlaySurface'
   * @see #getOverlaySurface()
   * @see #setOverlaySurface()
   */
  public native function get overlaySurface():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set overlaySurface(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>→reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState()</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default null
   * @since 5.0.0
   * @see #reference
   * @see #publishState()
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  public native function get publishes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set publishes(value:*):void;

  [ExtConfig]
  /**
   * Specifies a name for this component inside its component hierarchy. This name
   * must be unique within its <i>view</i> (→<code>ext.container.Container.referenceHolder</code>)
   * or its →<code>ext.app.ViewController</code>. See the documentation in
   * →<code>ext.container.Container</code> for more information about references.
   * <p><b>Note</b>: Valid identifiers start with a letter or underscore and are followed
   * by zero or more additional letters, underscores or digits. References are case
   * sensitive.</p>
   * @see ext.container.Container#referenceHolder
   * @see ext.app.ViewController
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-reference Original Ext JS documentation of 'reference'
   */
  public native function get reference():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set reference(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * A function that can be provided to set custom styling properties to each
   * rendered element. It receives <code>(sprite, config, rendererData, index)</code>
   * as parameters.
   * <ul>
   * <li><code>sprite:Object</code> —
   * The sprite affected by the renderer.
   * The visual attributes are in <code>sprite.attr</code>.
   * The data field is available in <code>sprite.getField()</code>.
   * </li>
   * <li><code>config:Object</code> —
   * The sprite configuration, which varies with the series
   * and the type of sprite. For instance, a Line chart sprite might have just the
   * <code>x</code> and <code>y</code> properties while a Bar chart sprite also has <code>width</code> and <code>height</code>.
   * A <code>→type</code> might be present too. For instance to draw each marker and each segment
   * of a Line chart, the renderer is called with the <code>config.type</code> set to either
   * <code>→marker</code> or <code>line</code>.
   * </li>
   * <li><code>rendererData:Object</code> —
   * A record with different properties depending on
   * the type of chart. The only guaranteed property is <code>rendererData.store</code>, the
   * store used by the series. In some cases, a store may not exist: for instance
   * a Gauge chart may read its value directly from its configuration; in this case
   * rendererData.store is null and the value is available in rendererData.value.
   * </li>
   * <li><code>index:Number</code> —
   * The index of the sprite. It is usually the index of the
   * store record associated with the sprite, in which case the record can be obtained
   * with <code>store.getData().items[index]</code>. If the chart is not associated with a store,
   * the index represents the index of the sprite within the series. For instance
   * a Gauge chart may have as many sprites as there are sectors in the background of
   * the gauge, plus one for the needle.
   * </li>
   * <li><code>null:Object</code> —
   * The attributes that have been changed or added.
   * Note: it is usually possible to add or modify the attributes directly into the
   * <code>config</code> parameter and not return anything, but returning an object with only
   * those attributes that have been changed may allow for optimizations in the
   * rendering of some series. Example to draw every other marker in red:
   * <pre>
   *  renderer: function (sprite, config, rendererData, index) {
   *      if (config.type === 'marker') {
   *          return { strokeStyle: (index % 2 === 0 ? 'red' : 'black') };
   *      }
   *  }
   * </pre>
   * </li>
   * </ul>
   * @see #type
   * @see #marker
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-renderer Original Ext JS documentation of 'renderer'
   * @see #getRenderer()
   * @see #setRenderer()
   */
  public native function get renderer():Function;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set renderer(value:Function):void;

  /**
   * Default series sprite type.
   * @default 'sprite'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#property-seriesType Original Ext JS documentation of 'seriesType'
   */
  public native function get seriesType():String;

  /**
   * @private
   */
  public native function set seriesType(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * If provided this creates a new <code>Session</code> instance for this component. If this
   * is a <code>Container</code>, this will then be inherited by all child components.
   * <p>To create a new session you can specify <code>true</code>:</p>
   * <pre>
   *  Ext.create({
   *      xtype: 'viewport',
   *      session: true,
   *
   *      items: [{
   *          ...
   *      }]
   *  });
   * </pre>
   * <p>Alternatively, a config object can be provided:</p>
   * <pre>
   *  Ext.create({
   *      xtype: 'viewport',
   *      session: {
   *          ...
   *      },
   *
   *      items: [{
   *          ...
   *      }]
   *  });
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-session Original Ext JS documentation of 'session'
   * @see #getSession()
   * @see #setSession()
   */
  public native function get session():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set session(value:*):void;

  [ExtConfig]
  /**
   * Set to <code>true</code> to allow this component's <code>name</code> to be shared by other items in the
   * same <code>nameHolder</code>. Such items will be returned in an array from <code>lookupName</code>.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-shareableName Original Ext JS documentation of 'shareableName'
   */
  public native function get shareableName():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set shareableName(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Whether to show this series in the legend.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-showInLegend Original Ext JS documentation of 'showInLegend'
   * @see #getShowInLegend()
   * @see #setShowInLegend()
   */
  public native function get showInLegend():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set showInLegend(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Whether markers should be displayed at the data points along the line. If true,
   * then the →<code>marker</code> config item will determine the markers' styling.
   * @default true
   * @see #marker
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-showMarkers Original Ext JS documentation of 'showMarkers'
   * @see #getShowMarkers()
   * @see #setShowMarkers()
   */
  public native function get showMarkers():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set showMarkers(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The store to use for this series. If not specified,
   * the series will use the chart's →<code>ext.chart.AbstractChart.store</code>.
   * @see ext.chart.AbstractChart#store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-store Original Ext JS documentation of 'store'
   * @see #getStore()
   * @see #setStore()
   */
  public native function get store():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set store(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Custom style configuration for the sprite used in the series.
   * It overrides the style that is provided by the current theme. See
   * →<code>ext.chart.theme.series.SeriesTheme</code>
   * @default {}
   * @see ext.chart.theme.series.SeriesTheme
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-style Original Ext JS documentation of 'style'
   * @see #getStyle()
   * @see #setStyle()
   */
  public native function get style():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set style(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * This is the cyclic used if the series has multiple sprites.
   * @default {}
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-subStyle Original Ext JS documentation of 'subStyle'
   * @see #getSubStyle()
   * @see #setSubStyle()
   */
  public native function get subStyle():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set subStyle(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The chart surface used to render series sprites.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-surface Original Ext JS documentation of 'surface'
   * @see #getSurface()
   * @see #setSurface()
   */
  public native function get surface():Surface;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set surface(value:Surface):void;

  [ExtConfig]
  [Bindable]
  /**
   * The human-readable name of the series (displayed in the legend).
   * If the series is stacked (has multiple components in it) this
   * should be an array, where each string corresponds to a stacked component.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-title Original Ext JS documentation of 'title'
   * @see #getTitle()
   * @see #setTitle()
   */
  public native function get title():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set title(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Add tooltips to the visualization's markers. The config options for the
   * tooltip are the same configuration used with →<code>ext.tip.ToolTip</code> plus a
   * <code>→renderer</code> config option and a <code>scope</code> for the renderer. For example:
   * <pre>
   * tooltip: {
   *   trackMouse: true,
   *   width: 140,
   *   height: 28,
   *   renderer: function (toolTip, record, ctx) {
   *       toolTip.setHtml(record.get('name') + ': ' + record.get('data1') + ' views');
   *   }
   * }
   * </pre>
   * <p>Note that tooltips are shown for series markers and won't work
   * if the →<code>marker</code> is not configured.</p>
   * <p>You can also configure
   * →<code>ext.chart.interactions.ItemHighlightInteraction.multiTooltips</code>
   * to display multiple tooltips for adjacent or overlapping Line series
   * data points within →<code>ext.chart.series.LineSeries.selectionTolerance</code> radius.</p>
   * <ul>
   * <li><code>scope:Object</code> (optional) —
   * The scope to use when the renderer function is
   * called. Defaults to the Series instance.
   * </li>
   * <li><code>renderer:Function</code> (optional) —
   * An 'interceptor' method which can be used to
   * modify the tooltip attributes before it is shown. The renderer function is
   * passed the following params:
   * <ul>
   * <li><code>toolTip:ext.tip.ToolTip</code> (optional) —
   * The tooltip instance
   * </li>
   * <li><code>record:ext.data.Model</code> (optional) —
   * The record instance for the
   * chart item (sprite) currently targeted by the tooltip.
   * </li>
   * <li><code>ctx:Object</code> (optional) —
   * A data object with values relating to the
   * currently targeted chart sprite
   * <ul>
   * <li><code>category:String</code> (optional) —
   * The type of sprite passed to the
   * renderer function (will be "items", "markers", or "labels" depending on the
   * target sprite of the tooltip)
   * </li>
   * <li><code>field:String</code> (optional) —
   * The →<code>yField</code> for the series
   * </li>
   * <li><code>index:Number</code> (optional) —
   * The target sprite's index within the
   * series' items
   * </li>
   * <li><code>record:ext.data.Model</code> (optional) —
   * The record instance for the
   * chart item (sprite) currently targeted by the tooltip.
   * </li>
   * <li><code>series:ext.chart.series.Series</code> (optional) —
   * The series instance
   * containing the tooltip's target sprite
   * </li>
   * <li><code>sprite:ext.draw.sprite.Sprite</code> (optional) —
   * The sprite (item)
   * target of the tooltip
   * </li>
   * </ul>
   * </li>
   * </ul>
   * </li>
   * </ul>
   * @see ext.tip.ToolTip
   * @see #renderer
   * @see #marker
   * @see ext.chart.interactions.ItemHighlightInteraction#multiTooltips
   * @see ext.chart.series.LineSeries#selectionTolerance
   * @see #yField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-tooltip Original Ext JS documentation of 'tooltip'
   * @see #getTooltip()
   * @see #setTooltip()
   */
  public native function get tooltip():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set tooltip(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * This object holds a map of <code>config</code> properties that will update their binding
   * as they are modified. For example, <code>value</code> is a key added by form fields. The
   * form of this config is the same as <code>→publishes</code>.
   * <p>This config is defined so that updaters are not created and added for all
   * bound properties since most cannot be modified by the end-user and hence are
   * not appropriate for two-way binding.</p>
   * @default null
   * @see #publishes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-twoWayBindable Original Ext JS documentation of 'twoWayBindable'
   * @see #getTwoWayBindable()
   * @see #setTwoWayBindable()
   */
  public native function get twoWayBindable():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set twoWayBindable(value:*):void;

  /**
   * The type of series. Set in subclasses.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#property-type Original Ext JS documentation of 'type'
   */
  public native function get type():String;

  /**
   * @private
   */
  public native function set type(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Colors for the series can be set directly through the 'colors' config, or indirectly
   * with the current theme or the 'colors' config that is set onto the chart. These colors
   * are used as "fill color". Set this config to true, if you want a darker color for the
   * strokes. Set it to false if you want to use the same color as the fill color.
   * Alternatively, you can set it to a number between 0 and 1 to control how much darker
   * the strokes should be.
   * Note: this should be initial config and cannot be changed later on.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#cfg-useDarkerStrokeColor Original Ext JS documentation of 'useDarkerStrokeColor'
   * @see #getUseDarkerStrokeColor()
   * @see #setUseDarkerStrokeColor()
   */
  public native function get useDarkerStrokeColor():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set useDarkerStrokeColor(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The <code>ViewModel</code> is a data provider for this component and its children. The
   * data contained in the <code>ViewModel</code> is typically used by adding <code>→bind</code> configs
   * to the components that want present or edit this data.
   * <p>When set, the <code>ViewModel</code> is created and links to any inherited <code>→viewModel</code>
   * instance from an ancestor container as the "parent". The <code>ViewModel</code> hierarchy,
   * once established, only supports creation or destruction of children. The
   * parent of a <code>ViewModel</code> cannot be changed on the fly.</p>
   * <p>If this is a root-level <code>ViewModel</code>, the data model connection is made to this
   * component's associated <code>Data Session (→ext.data.Session)</code>. This is
   * determined by calling <code>getInheritedSession</code>.</p>
   * @default null
   * @see #bind
   * @see #viewModel
   * @see ext.data.Session
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-viewModel Original Ext JS documentation of 'viewModel'
   * @see #getViewModel()
   * @see #setViewModel()
   */
  public native function get viewModel():ViewModel;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set viewModel(value:ViewModel):void;

  /**
   * Returns the value of <code>animation</code>.
   * @see #animation
   */
  public native function getAnimation():Object;

  /**
   * Returns the value of <code>background</code>.
   * @see #background
   */
  public native function getBackground():Object;

  /**
   * Returns the value of <code>bind</code>.
   * @see #bind
   */
  public native function getBind():*;

  /**
   * Returns the value of <code>colors</code>.
   * @see #colors
   */
  public native function getColors():Array;

  /**
   * Returns the value of <code>controller</code>.
   * @see #controller
   */
  public native function getController():*;

  /**
   * Returns the value of <code>defaultListenerScope</code>.
   * @see #defaultListenerScope
   */
  public native function getDefaultListenerScope():Boolean;

  /**
   * Returns the value of <code>hidden</code>.
   * @see #hidden
   */
  public native function getHidden():*;

  /**
   * Returns the value of <code>highlight</code>.
   * @see #highlight
   */
  public native function getHighlight():*;

  /**
   * Returns the value of <code>highlightCfg</code>.
   * @see #highlightCfg
   */
  public native function getHighlightCfg():Object;

  /**
   * Returns a series item by index and (optional) category.
   * @param index The index of the item (matches store record index).
   * @param category The category of item, e.g.: 'items', 'markers', 'sprites'.
   * @return item
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#method-getItemByIndex Original Ext JS documentation of 'getItemByIndex'
   */
  public native function getItemByIndex(index:Number, category:String = null):Object;

  /**
   * For a given x/y point relative to the main rect, find a corresponding item from this
   * series, if any.
   * @param x
   * @param y
   * @param target optional target to receive the result
   * @return An object describing the item, or null if there is no matching item.
   * The exact contents of this object will vary by series type, but should always contain
   * at least the following:
   * <ul>
   * <li><code>record:ext.data.Model</code> (optional) —
   * the record of the item.
   * </li>
   * <li><code>point:Array</code> (optional) —
   * the x/y coordinates relative to the chart box
   * of a single point for this data item, which can be used as e.g. a tooltip anchor
   * point.
   * </li>
   * <li><code>sprite:ext.draw.sprite.Sprite</code> (optional) —
   * the item's rendering Sprite.
   * </li>
   * <li><code>subSprite:Number</code> (optional) —
   * the index if sprite is an instancing sprite.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#method-getItemForPoint Original Ext JS documentation of 'getItemForPoint'
   */
  public native function getItemForPoint(x:Number, y:Number, target:Object = null):Object;

  /**
   * Returns the value of <code>itemInstancing</code>.
   * @see #itemInstancing
   */
  public native function getItemInstancing():Object;

  /**
   * Returns the value of <code>label</code>.
   * @see #label
   */
  public native function getLabel():Object;

  /**
   * Returns the value of <code>labelOverflowPadding</code>.
   * @see #labelOverflowPadding
   */
  public native function getLabelOverflowPadding():Number;

  /**
   * Returns the value of <code>marker</code>.
   * @see #marker
   */
  public native function getMarker():*;

  /**
   * Returns the value of <code>markerSubStyle</code>.
   * @see #markerSubStyle
   */
  public native function getMarkerSubStyle():Object;

  /**
   * Returns the value of <code>overlaySurface</code>.
   * @see #overlaySurface
   */
  public native function getOverlaySurface():Object;

  /**
   * Returns the value of <code>publishes</code>.
   * @see #publishes
   */
  public native function getPublishes():*;

  /**
   * Returns the value of <code>renderer</code>.
   * @see #renderer
   */
  public native function getRenderer():Function;

  /**
   * Returns the value of <code>session</code>.
   * @see #session
   */
  public native function getSession():*;

  /**
   * Returns the value of <code>showInLegend</code>.
   * @see #showInLegend
   */
  public native function getShowInLegend():Boolean;

  /**
   * Returns the value of <code>showMarkers</code>.
   * @see #showMarkers
   */
  public native function getShowMarkers():Boolean;

  /**
   * Returns the read-only array of sprites the are used to draw this series.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#method-getSprites Original Ext JS documentation of 'getSprites'
   */
  public native function getSprites():void;

  /**
   * Returns the value of <code>store</code>.
   * @see #store
   */
  public native function getStore():Object;

  /**
   * Returns the value of <code>style</code>.
   * @see #style
   */
  public native function getStyle():Object;

  /**
   * Returns the value of <code>subStyle</code>.
   * @see #subStyle
   */
  public native function getSubStyle():Object;

  /**
   * Returns the value of <code>surface</code>.
   * @see #surface
   */
  public native function getSurface():Surface;

  /**
   * Returns the value of <code>title</code>.
   * @see #title
   */
  public native function getTitle():*;

  /**
   * Returns the value of <code>tooltip</code>.
   * @see #tooltip
   */
  public native function getTooltip():Object;

  /**
   * Returns the value of <code>twoWayBindable</code>.
   * @see #twoWayBindable
   */
  public native function getTwoWayBindable():*;

  /**
   * Returns the value of <code>useDarkerStrokeColor</code>.
   * @see #useDarkerStrokeColor
   */
  public native function getUseDarkerStrokeColor():*;

  /**
   * Returns the value of <code>viewModel</code>.
   * @see #viewModel
   */
  public native function getViewModel():*;

  /**
   * Called by <code>getInherited</code> to initialize the inheritedState the first time it is
   * requested.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#method-initInheritedState Original Ext JS documentation of 'initInheritedState'
   */
  protected native function initInheritedState(inheritedState:*):void;

  /**
   * @inheritDoc
   */
  public native function isBound(name:String = null):Boolean;

  /**
   * @inheritDoc
   */
  public native function lookupController(skipThis:Boolean = false):ViewController;

  /**
   * @inheritDoc
   */
  public native function lookupSession(skipThis:Boolean = false):Session;

  /**
   * @inheritDoc
   */
  public native function lookupViewModel(skipThis:Boolean = false):ViewModel;

  /**
   * Provide legend information to target array.
   * @param target The information consists:
   * <ul>
   * <li><code>name:String</code> (optional)</li>
   * <li><code>mark:String</code> (optional)</li>
   * <li><code>disabled:Boolean</code> (optional)</li>
   * <li><code>series:String</code> (optional)</li>
   * <li><code>index:Number</code> (optional)</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#method-provideLegendInfo Original Ext JS documentation of 'provideLegendInfo'
   */
  public native function provideLegendInfo(target:Array):void;

  /**
   * Publish this components state to the <code>ViewModel</code>. If no arguments are given (or if
   * this is the first call), the entire state is published. This state is determined by
   * the <code>→publishes</code> property.
   * <p>This method is called only by component authors.</p>
   * @since 5.0.0
   * @param property The name of the property to update.
   * @param value The value of <code>property</code>. Only needed if <code>property</code> is given.
   * @see #publishes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#method-publishState Original Ext JS documentation of 'publishState'
   */
  protected native function publishState(property:String = null, value:Object = null):void;

  /**
   * Sets the value of <code>animation</code>.
   * @param animation The new value.
   * @see #animation
   */
  public native function setAnimation(animation:Object):void;

  /**
   * Sets the value of <code>background</code>.
   * @param background The new value.
   * @see #background
   */
  public native function setBackground(background:Object):void;

  /**
   * Sets the value of <code>bind</code>.
   * @param bind The new value.
   * @see #bind
   */
  public native function setBind(bind:*):void;

  /**
   * Sets the value of <code>colors</code>.
   * @param colors The new value.
   * @see #colors
   */
  public native function setColors(colors:Array):void;

  /**
   * Sets the value of <code>controller</code>.
   * @param controller The new value.
   * @see #controller
   */
  public native function setController(controller:*):void;

  /**
   * Sets the value of <code>defaultListenerScope</code>.
   * @param defaultListenerScope The new value.
   * @see #defaultListenerScope
   */
  public native function setDefaultListenerScope(defaultListenerScope:Boolean):void;

  /**
   * Sets the value of <code>hidden</code>.
   * @param hidden The new value.
   * @see #hidden
   */
  public native function setHidden(hidden:*):void;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#method-setHiddenByIndex Original Ext JS documentation of 'setHiddenByIndex'
   */
  public native function setHiddenByIndex(index:Number, value:Boolean):void;

  /**
   * Sets the value of <code>highlight</code>.
   * @param highlight The new value.
   * @see #highlight
   */
  public native function setHighlight(highlight:*):void;

  /**
   * Sets the value of <code>highlightCfg</code>.
   * @param highlightCfg The new value.
   * @see #highlightCfg
   */
  public native function setHighlightCfg(highlightCfg:Object):void;

  /**
   * Sets the value of <code>itemInstancing</code>.
   * @param itemInstancing The new value.
   * @see #itemInstancing
   */
  public native function setItemInstancing(itemInstancing:Object):void;

  /**
   * Sets the value of <code>label</code>.
   * @param label The new value.
   * @see #label
   */
  public native function setLabel(label:Object):void;

  /**
   * Sets the value of <code>labelOverflowPadding</code>.
   * @param labelOverflowPadding The new value.
   * @see #labelOverflowPadding
   */
  public native function setLabelOverflowPadding(labelOverflowPadding:Number):void;

  /**
   * Sets the value of <code>marker</code>.
   * @param marker The new value.
   * @see #marker
   */
  public native function setMarker(marker:*):void;

  /**
   * Sets the value of <code>markerSubStyle</code>.
   * @param markerSubStyle The new value.
   * @see #markerSubStyle
   */
  public native function setMarkerSubStyle(markerSubStyle:Object):void;

  /**
   * Sets the value of <code>overlaySurface</code>.
   * @param overlaySurface The new value.
   * @see #overlaySurface
   */
  public native function setOverlaySurface(overlaySurface:Object):void;

  /**
   * Sets the value of <code>publishes</code>.
   * @param publishes The new value.
   * @see #publishes
   */
  public native function setPublishes(publishes:*):void;

  /**
   * Sets the value of <code>renderer</code>.
   * @param renderer The new value.
   * @see #renderer
   */
  public native function setRenderer(renderer:Function):void;

  /**
   * Sets the value of <code>session</code>.
   * @param session The new value.
   * @see #session
   */
  public native function setSession(session:*):void;

  /**
   * Sets the value of <code>showInLegend</code>.
   * @param showInLegend The new value.
   * @see #showInLegend
   */
  public native function setShowInLegend(showInLegend:Boolean):void;

  /**
   * Sets the value of <code>showMarkers</code>.
   * @param showMarkers The new value.
   * @see #showMarkers
   */
  public native function setShowMarkers(showMarkers:Boolean):void;

  /**
   * Sets the value of <code>store</code>.
   * @param store The new value.
   * @see #store
   */
  public native function setStore(store:Object):void;

  /**
   * Sets the value of <code>style</code>.
   * @param style The new value.
   * @see #style
   */
  public native function setStyle(style:Object):void;

  /**
   * Sets the value of <code>subStyle</code>.
   * @param subStyle The new value.
   * @see #subStyle
   */
  public native function setSubStyle(subStyle:Object):void;

  /**
   * Sets the value of <code>surface</code>.
   * @param surface The new value.
   * @see #surface
   */
  public native function setSurface(surface:Surface):void;

  /**
   * Sets the value of <code>title</code>.
   * @param title The new value.
   * @see #title
   */
  public native function setTitle(title:*):void;

  /**
   * Sets the value of <code>tooltip</code>.
   * @param tooltip The new value.
   * @see #tooltip
   */
  public native function setTooltip(tooltip:Object):void;

  /**
   * Sets the value of <code>twoWayBindable</code>.
   * @param twoWayBindable The new value.
   * @see #twoWayBindable
   */
  public native function setTwoWayBindable(twoWayBindable:*):void;

  /**
   * Sets the value of <code>useDarkerStrokeColor</code>.
   * @param useDarkerStrokeColor The new value.
   * @see #useDarkerStrokeColor
   */
  public native function setUseDarkerStrokeColor(useDarkerStrokeColor:*):void;

  /**
   * Sets the value of <code>viewModel</code>.
   * @param viewModel The new value.
   * @see #viewModel
   */
  public native function setViewModel(viewModel:*):void;
}
}