package ext.chart.series {

[Native("Ext.chart.series.StackedCartesian", require)]
/**
 * Abstract class for all the stacked cartesian series including area series
 * and bar series.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.StackedCartesian.html Original Ext JS documentation of 'Ext.chart.series.StackedCartesian'
 */
public class StackedCartesianSeries extends CartesianSeries {
  /**
   * @inheritDoc
   */
  public function StackedCartesianSeries(config:StackedCartesianSeries = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * If <code>true</code>, the height of a stacked bar is always the full height of the chart,
   * with individual components viewed as shares of the whole determined by the
   * →<code>fullStackTotal</code> config.
   * @default false
   * @see #fullStackTotal
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.StackedCartesian.html#cfg-fullStack Original Ext JS documentation of 'fullStack'
   * @see #getFullStack()
   * @see #setFullStack()
   */
  public native function get fullStack():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set fullStack(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * If the →<code>fullStack</code> config is set to <code>true</code>, this will determine
   * the absolute total value of each stack.
   * @default 100
   * @see #fullStack
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.StackedCartesian.html#cfg-fullStackTotal Original Ext JS documentation of 'fullStackTotal'
   * @see #getFullStackTotal()
   * @see #setFullStackTotal()
   */
  public native function get fullStackTotal():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set fullStackTotal(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * @default []
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.StackedCartesian.html#cfg-hidden Original Ext JS documentation of 'hidden'
   * @see #getHidden()
   * @see #setHidden()
   */
  override public native function get hidden():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set hidden(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to stack negative/positive values in respective y-axis directions.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.StackedCartesian.html#cfg-splitStacks Original Ext JS documentation of 'splitStacks'
   * @see #getSplitStacks()
   * @see #setSplitStacks()
   */
  public native function get splitStacks():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set splitStacks(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to display the series in its stacked configuration.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.StackedCartesian.html#cfg-stacked Original Ext JS documentation of 'stacked'
   * @see #getStacked()
   * @see #setStacked()
   */
  public native function get stacked():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set stacked(value:Boolean):void;

  /**
   * Returns the value of <code>fullStack</code>.
   * @see #fullStack
   */
  public native function getFullStack():Boolean;

  /**
   * Returns the value of <code>fullStackTotal</code>.
   * @see #fullStackTotal
   */
  public native function getFullStackTotal():Boolean;

  /**
   * Returns the value of <code>hidden</code>.
   * @see #hidden
   */
  override public native function getHidden():*;

  /**
   * Returns the value of <code>splitStacks</code>.
   * @see #splitStacks
   */
  public native function getSplitStacks():Boolean;

  /**
   * Returns the value of <code>stacked</code>.
   * @see #stacked
   */
  public native function getStacked():Boolean;

  /**
   * Sets the value of <code>fullStack</code>.
   * @param fullStack The new value.
   * @see #fullStack
   */
  public native function setFullStack(fullStack:Boolean):void;

  /**
   * Sets the value of <code>fullStackTotal</code>.
   * @param fullStackTotal The new value.
   * @see #fullStackTotal
   */
  public native function setFullStackTotal(fullStackTotal:Boolean):void;

  /**
   * Sets the value of <code>hidden</code>.
   * @param hidden The new value.
   * @see #hidden
   */
  override public native function setHidden(hidden:*):void;

  /**
   * Sets the value of <code>splitStacks</code>.
   * @param splitStacks The new value.
   * @see #splitStacks
   */
  public native function setSplitStacks(splitStacks:Boolean):void;

  /**
   * Sets the value of <code>stacked</code>.
   * @param stacked The new value.
   * @see #stacked
   */
  public native function setStacked(stacked:Boolean):void;
}
}