package ext.chart.series.events {
import ext.chart.series.Series;

import js.Event;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.chart.series.events.Series_item_eventEvent")]
public class Series_item_eventEvent extends FlExtEvent {
  /**
   * Fires when a click event occurs on a series item.
   * <i>Note</i>: This event requires the <i>chartitemevents</i> (→<code>ext.chart.plugin.ChartItemEventsPlugin</code>)
   * plugin be added to the chart.
   * @see ext.chart.plugin.ChartItemEventsPlugin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#event-itemclick Original Ext JS documentation of 'itemclick'
   * @see ext.chart.series.Series
   * @eventType onItemClick
   */
  public static const ITEM_CLICK:String = "onItemClick";
  /**
   * Fires when a double click event occurs on a series item.
   * <i>Note</i>: This event requires the <i>chartitemevents</i> (→<code>ext.chart.plugin.ChartItemEventsPlugin</code>)
   * plugin be added to the chart.
   * @see ext.chart.plugin.ChartItemEventsPlugin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#event-itemdblclick Original Ext JS documentation of 'itemdblclick'
   * @see ext.chart.series.Series
   * @eventType onItemDblclick
   */
  public static const ITEM_DBLCLICK:String = "onItemDblclick";
  /**
   * Fires when a mousedown event occurs on a series item.
   * <i>Note</i>: This event requires the <i>chartitemevents</i> (→<code>ext.chart.plugin.ChartItemEventsPlugin</code>)
   * plugin be added to the chart.
   * @see ext.chart.plugin.ChartItemEventsPlugin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#event-itemmousedown Original Ext JS documentation of 'itemmousedown'
   * @see ext.chart.series.Series
   * @eventType onItemMouseDown
   */
  public static const ITEM_MOUSE_DOWN:String = "onItemMouseDown";
  /**
   * Fires when the mouse is moved on a series item.
   * <i>Note</i>: This event requires the <i>chartitemevents</i> (→<code>ext.chart.plugin.ChartItemEventsPlugin</code>)
   * plugin be added to the chart.
   * @see ext.chart.plugin.ChartItemEventsPlugin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#event-itemmousemove Original Ext JS documentation of 'itemmousemove'
   * @see ext.chart.series.Series
   * @eventType onItemMouseMove
   */
  public static const ITEM_MOUSE_MOVE:String = "onItemMouseMove";
  /**
   * Fires when the mouse exits a series item.
   * <i>Note</i>: This event requires the <i>chartitemevents</i> (→<code>ext.chart.plugin.ChartItemEventsPlugin</code>)
   * plugin be added to the chart.
   * @see ext.chart.plugin.ChartItemEventsPlugin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#event-itemmouseout Original Ext JS documentation of 'itemmouseout'
   * @see ext.chart.series.Series
   * @eventType onItemMouseOut
   */
  public static const ITEM_MOUSE_OUT:String = "onItemMouseOut";
  /**
   * Fires when the mouse enters a series item.
   * <i>Note</i>: This event requires the <i>chartitemevents</i> (→<code>ext.chart.plugin.ChartItemEventsPlugin</code>)
   * plugin be added to the chart.
   * @see ext.chart.plugin.ChartItemEventsPlugin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#event-itemmouseover Original Ext JS documentation of 'itemmouseover'
   * @see ext.chart.series.Series
   * @eventType onItemMouseOver
   */
  public static const ITEM_MOUSE_OVER:String = "onItemMouseOver";
  /**
   * Fires when a mouseup event occurs on a series item.
   * <i>Note</i>: This event requires the <i>chartitemevents</i> (→<code>ext.chart.plugin.ChartItemEventsPlugin</code>)
   * plugin be added to the chart.
   * @see ext.chart.plugin.ChartItemEventsPlugin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#event-itemmouseup Original Ext JS documentation of 'itemmouseup'
   * @see ext.chart.series.Series
   * @eventType onItemMouseUp
   */
  public static const ITEM_MOUSE_UP:String = "onItemMouseUp";
  /**
   * Fires when a tap event occurs on a series item.
   * <i>Note</i>: This event requires the <i>chartitemevents</i> (→<code>ext.chart.plugin.ChartItemEventsPlugin</code>)
   * plugin be added to the chart.
   * @see ext.chart.plugin.ChartItemEventsPlugin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.Series.html#event-itemtap Original Ext JS documentation of 'itemtap'
   * @see ext.chart.series.Series
   * @eventType onItemTap
   */
  public static const ITEM_TAP:String = "onItemTap";
  public static const __PARAMETER_SEQUENCE__:Array = ["series", "item", "event", "eOpts"];

  public function Series_item_eventEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  public native function get event():Event;

  public native function get item():Object;

  public native function get series():Series;
}
}