package ext.chart.series.sprite {
[Native("Ext.chart.series.sprite.Bar3D", require)]
/**
 * Draws a sprite used in →<code>ext.chart.series.Bar3DSeries</code> series.
 * @see ext.chart.series.Bar3DSeries
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Bar3D.html Original Ext JS documentation of 'Ext.chart.series.sprite.Bar3D'
 */
public class Bar3DSeriesSprite extends BarSeriesSprite {
  /**
   * @inheritDoc
   */
  public function Bar3DSeriesSprite(config:Bar3DSeriesSprite = null) {
    super();
  }

  [ExtConfig]
  /**
   * The factor applied to the brightness of the bars.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Bar3D.html#cfg-brightnessFactor Original Ext JS documentation of 'brightnessFactor'
   */
  public native function get brightnessFactor():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set brightnessFactor(value:Number):void;

  [ExtConfig]
  /**
   * An attribute used to control how flat the bar gradient looks.
   * A value of 0 essentially means no gradient (flat color).
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Bar3D.html#cfg-colorSpread Original Ext JS documentation of 'colorSpread'
   */
  public native function get colorSpread():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set colorSpread(value:Number):void;

  [ExtConfig]
  /**
   * The factor applied to the saturation of the bars.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Bar3D.html#cfg-saturationFactor Original Ext JS documentation of 'saturationFactor'
   */
  public native function get saturationFactor():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set saturationFactor(value:Number):void;
}
}